/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.enums.CodeEnum;
import com.thebeastshop.common.enums.IdEnum;
import com.thebeastshop.common.validation.Validation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EnumUtil {
    private static final ConcurrentHashMap<Class, Map<Object, Object>> enumCodeCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class, Map<Object, Object>> enumIdCache = new ConcurrentHashMap();

    public static <T, V> V getPropertyById(Integer id, Class<T> cls, String propertyName) {
        if (id == null) {
            return null;
        }
        try {
            Method method = cls.getMethod("getEnumById", Integer.class);
            if (method == null) {
                return null;
            }
            String result = method.invoke(null, id).toString();
            if (result == null) {
                return null;
            }
            String getterName = "get" + (propertyName.charAt(0) + "").toUpperCase() + propertyName.substring(1);
            Method getterMethod = cls.getMethod(getterName, new Class[0]);
            if (getterMethod == null) {
                return null;
            }
            return (V)getterMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String getNameById(Integer id, Class<T> cls) {
        String result = (String)EnumUtil.getPropertyById(id, cls, "name");
        return result == null ? "" : result;
    }

    public static <T extends CodeEnum> T getByName(Class<T> enumClass, String name) {
        CodeEnum[] arr;
        Validation.paramNotNull(enumClass, "enumClass\u4e3a\u7a7a");
        Validation.paramNotEmpty(name, "name\u4e3a\u7a7a");
        for (CodeEnum item : arr = (CodeEnum[])EnumUtil.getAll(enumClass)) {
            if (!name.equals(item.getName())) continue;
            return (T)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C, T extends CodeEnum<C>> T getByCode(Class<T> enumClass, C code) {
        Validation.paramNotNull(enumClass, "enumClass\u4e3a\u7a7a");
        Validation.paramNotNull(code, "code\u4e3a\u7a7a");
        Map<Object, Object> map = enumCodeCache.get(enumClass);
        if (map == null) {
            Class<T> clazz = enumClass;
            synchronized (clazz) {
                if (!enumCodeCache.contains(enumClass)) {
                    CodeEnum[] arr = (CodeEnum[])EnumUtil.getAll(enumClass);
                    map = new HashMap<Object, Object>();
                    for (CodeEnum item : arr) {
                        map.put(item.getCode(), item);
                    }
                    enumCodeCache.put(enumClass, map);
                }
            }
        }
        return (T)((CodeEnum)map.get(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IdEnum, ID> T getById(Class<T> enumClass, ID id) {
        Validation.paramNotNull(enumClass, "enumClass\u4e3a\u7a7a");
        Validation.paramNotNull(id, "id\u4e3a\u7a7a");
        Map<Object, Object> map = enumIdCache.get(enumClass);
        if (map == null) {
            Class<T> clazz = enumClass;
            synchronized (clazz) {
                if (!enumIdCache.contains(enumClass)) {
                    IdEnum[] arr = (IdEnum[])EnumUtil.getAll(enumClass);
                    map = new HashMap<Object, Object>();
                    for (IdEnum item : arr) {
                        map.put(item.getId(), item);
                    }
                    enumIdCache.put(enumClass, map);
                }
            }
        }
        return (T)((IdEnum)map.get(id));
    }

    public static <T extends Enum> List<T> getAllAsList(Class<T> enumClass) {
        Enum[] arr = (Enum[])EnumUtil.getAll(enumClass);
        ArrayList<Enum> list = new ArrayList<Enum>();
        for (Enum item : arr) {
            list.add(item);
        }
        return list;
    }

    public static <T> T[] getAll(Class<T> enumClass) {
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3a\u679a\u4e3e\u7c7bClass");
        }
        try {
            Method valuesMethod = enumClass.getDeclaredMethod("values", new Class[0]);
            Object values = valuesMethod.invoke(enumClass, new Object[0]);
            Validation.assertTrue(values.getClass().isArray(), "" + enumClass.getName() + ".values() \u7ed3\u679c\u548c\u9884\u671f\u4e0d\u540c");
            return (Object[])values;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

