/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.thebeastshop.common.converter.BeanConverter;
import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.BeanFieldConverter;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.ToList;
import com.thebeastshop.common.enums.CodeEnum;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GenericBeanConverter
implements BeanConverter {
    @Override
    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }

    protected static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }

    @Override
    public <T> T converterFrom(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        Object ret = null;
        try {
            ret = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        BeanConverterHandlerManager handlerManager = GenericBeanConverter.matchHandlerManager(fromClass, clazz);
        if (handlerManager != null) {
            String[] ignoreFields = handlerManager.getIgnoreFields();
            GenericBeanConverter.copyProperties(obj, ret, ignoreFields);
            handlerManager.afterCopyProperties(obj, ret);
        } else {
            BeanUtils.copyProperties((Object)obj, ret);
        }
        return (T)ret;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        GenericBeanConverter.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Class<?> readType;
            Class<?> writeType;
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !GenericBeanConverter.checkType(writeType = writeMethod.getParameterTypes()[0], readType = readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, BeanFieldConverter.convert(value, readType, writeType));
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    private static boolean checkType(Class writeType, Class readType) {
        if (ClassUtils.isAssignable((Class)writeType, (Class)readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(writeType) && Boolean.class.isAssignableFrom(readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(readType) && Boolean.class.isAssignableFrom(writeType)) {
            return true;
        }
        return CodeEnum.class.isAssignableFrom(readType) || CodeEnum.class.isAssignableFrom(writeType);
    }

    @Override
    public <T> List<T> converterListFrom(List list, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (Object obj : list) {
            results.add(this.converterFrom(obj, clazz));
        }
        return results;
    }

    public GenericBeanConverter() {
        this.init();
    }

    protected void init() {
    }
}

