/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import com.google.common.base.Preconditions;
import com.thebeastshop.common.prop.PropChange;
import com.thebeastshop.common.prop.PropChangeCallback;
import com.thebeastshop.common.prop.PropConstants;
import com.thebeastshop.common.prop.annotation.DynamicPropAccessor;
import com.thebeastshop.common.prop.annotation.DynamicPropValue;
import com.thebeastshop.common.prop.annotation.PropOnChange;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class PropAnnotationProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private static final Logger log = LoggerFactory.getLogger(PropAnnotationProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        this.processFields(bean, clazz.getDeclaredFields());
        this.processMethods(bean, clazz.getDeclaredMethods());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private void processFields(Object bean, Field[] declaredFields) {
        for (Field field : declaredFields) {
            this.processDynamicPropValueAnn(bean, field);
        }
    }

    private void processDynamicPropValueAnn(Object bean, Field field) {
        DynamicPropValue annotation = (DynamicPropValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, DynamicPropValue.class);
        if (annotation == null) {
            return;
        }
        String propName = annotation.value();
        ReflectionUtils.makeAccessible((Field)field);
        DynamicPropAccessor propAccessor = new DynamicPropAccessor(propName, bean, field);
        PropConstants.registerPropAccessor(bean.getClass().getName() + "@" + bean.hashCode(), propName, propAccessor);
        propAccessor.refreshValue();
    }

    private void processMethods(final Object bean, Method[] declaredMethods) {
        for (final Method method : declaredMethods) {
            PropOnChange annotation = (PropOnChange)AnnotationUtils.findAnnotation((Method)method, PropOnChange.class);
            if (annotation == null) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (Object[])new Object[]{parameterTypes.length, method});
            Preconditions.checkArgument((boolean)PropChange.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", (Object[])new Object[]{parameterTypes[0], method});
            String propName = annotation.value();
            log.info("%%%% \u626b\u63cf\u5230@PropOnChange\u6ce8\u89e3 PropName: " + propName + " Class: " + bean.getClass().getName() + " Method: " + method.getName());
            ReflectionUtils.makeAccessible((Method)method);
            String beanId = bean.getClass().getName() + "@" + bean.hashCode();
            PropConstants.addPropChangeCallback(beanId, propName, new PropChangeCallback(){

                @Override
                public void onChange(PropChange propChange) {
                    ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{propChange});
                }
            });
        }
    }
}

