/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RedissonClient redissonClient;

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key).isExists();
    }

    public <T> List<T> mutiGet(List<String> keys) {
        return new ArrayList(this.redissonClient.getBuckets().get(keys.toArray(new String[keys.size()])).values());
    }

    public <T> void putCache(String key, T t, Long timeOut) {
        this.putCache(key, t, timeOut, TimeUnit.SECONDS);
    }

    public <T> void putCache(String key, T t) {
        this.putCache(key, t, null, null);
    }

    public <T> void putCache(String key, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.redissonClient.getBucket(key);
            if (timeOut == null) {
                bucket.set(t);
            } else {
                bucket.set(t, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllCache(Map<String, T> map, Long liveTimeSec) {
        try {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync rMapAsync = null;
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rMapAsync = batch.getBucket(entry.getKey());
                rMapAsync.setAsync(entry.getValue(), liveTimeSec.longValue(), TimeUnit.SECONDS);
            }
            batch.execute();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> T getCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getBucket(key).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllHashCache(String key, Map<String, T> map) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBatch batch = this.redissonClient.createBatch();
            RMapAsync rMapAsync = batch.getMap(key);
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rMapAsync.fastPutAsync((Object)entry.getKey(), entry.getValue());
            }
            batch.execute();
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllHashCache(String key, Map<String, T> map, Long liveTimeSec) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBatch batch = this.redissonClient.createBatch();
            RMapAsync rmapAsync = batch.getMap(key);
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rmapAsync.fastPutAsync((Object)entry.getKey(), entry.getValue());
            }
            rmapAsync.expireAsync(liveTimeSec.longValue(), TimeUnit.SECONDS);
            batch.execute();
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putHashCache(String key, String hashKey, T t) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            rmap.fastPut((Object)hashKey, t);
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getHashCache(String key, String hashKey) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"getHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getMap(key).get((Object)hashKey);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> List<T> mutiHashGet(String key, List<String> hashKeyList) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"mutiGetHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            ArrayList<Object> result = new ArrayList<Object>();
            for (String hashKey : hashKeyList) {
                result.add(rmap.get((Object)hashKey));
            }
            trans.setSuccessStatus();
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec) {
        return this.getLocalCacheMap(key, cacheSize, timeToLiveSec, false);
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec, boolean syncOnChange) {
        LocalCachedMapOptions options = LocalCachedMapOptions.defaults().evictionPolicy(LocalCachedMapOptions.EvictionPolicy.LFU).cacheSize(cacheSize.intValue()).invalidateEntryOnChange(syncOnChange).timeToLive(timeToLiveSec.longValue(), TimeUnit.SECONDS).maxIdle(0L);
        RLocalCachedMap map = this.redissonClient.getLocalCachedMap(key, options);
        return map;
    }

    public <T> BlockingQueue<T> getReddisonQueue(String queueName, boolean fair) {
        if (fair) {
            return this.redissonClient.getBlockingQueue(queueName);
        }
        return this.redissonClient.getBlockingFairQueue(queueName);
    }

    public boolean delCache(String key) {
        return this.redissonClient.getBucket(key).delete();
    }

    public <T> T executeScript(String scriptStr) {
        return (T)this.redissonClient.getScript().eval(RScript.Mode.READ_ONLY, scriptStr, RScript.ReturnType.VALUE);
    }

    public Future<Object> executeScriptAsync(String scriptStr) {
        RScript s = this.redissonClient.getScript();
        String sha = s.scriptLoad(scriptStr);
        return s.evalShaAsync(RScript.Mode.READ_ONLY, sha, RScript.ReturnType.VALUE, Collections.emptyList(), new Object[0]);
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

