/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.exception;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;

public class BaseServiceException
extends RuntimeException {
    private final String appId = PropConstants.getAppId();
    private String errorCode;

    public BaseServiceException(String errorCode) {
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public BaseServiceException(BaseErrorCode exceptionCode) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage());
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg) {
        this(exceptionCode.getErrorCode(), BaseServiceException.errorMessage(exceptionCode, msg));
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg, Throwable cause) {
        this(exceptionCode.getErrorCode(), msg, cause);
    }

    public BaseServiceException(String errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getAppId() {
        return this.appId;
    }

    private static String errorMessage(BaseErrorCode exceptionCode, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return exceptionCode.getMessage() + ": " + msg;
        }
        return exceptionCode.getMessage();
    }
}

