package com.thebeastshop.cart.service;

import com.thebeastshop.cart.TempCart;
import com.thebeastshop.cart.req.TempCartPackCondition;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;

import java.util.Collection;
import java.util.List;

/**
 * Created by GFL on 2017/7/12.
 */
public interface TempCartService {


    /**
     * 获取关联的临时购物车
     *
     * @param binding
     * @return 若该用户购物车为空，不返回null，返回一个空的Cart
     */
    @Deprecated
    TempCart getByBinding(final String binding, String tbsId, AccessWayEnum accessWay);
    @Deprecated
    List<TempCartProductPack> getPacksByIds(final String binding, String tbsId, List<Long> ids, AccessWayEnum accessWay);
    TempCart getByBinding(final String binding, String tbsId, AccessWayEnum accessWay,String channelCode);

    List<TempCartProductPack> getPacksByIds(final String binding, String tbsId, List<Long> ids, AccessWayEnum accessWay,String channelCode);
    /**
     * 根据条件查询
     * @param condition
     * @param accessWay
     * @return
     */
    @Deprecated
    List<TempCartProductPack> findByCondition(TempCartPackCondition condition, AccessWayEnum accessWay);
    List<TempCartProductPack> findByCondition(TempCartPackCondition condition, AccessWayEnum accessWay,String channelCode);
    /**
     * 将一个商品包加入临时购物车。 如果该商品包已存在，但主人不是指定购物车的主人（这是偷窃），则抛出异常。
     * 如果该商品包的商品已存在于指定的临时购物车中，则将该商品包合并到已存在的商品包中。
     *
     * @param binding
     * @param pack
     */
    TempCartProductPack addPack(final String binding, String tbsId, final TempCartProductPack pack, AccessWayEnum accessWay);


    /**
     * 将一些商品包加入临时购物车。 如果该商品包已存在，但主人不是指定购物车的主人（这是偷窃），则抛出异常。
     * 如果该商品包的商品已存在于指定的购物车中，则将该商品包合并到已存在的商品包中。
     *
     * @param binding
     * @param packs
     */
    @Deprecated
    List<TempCartProductPack> addPacks(final String binding, String tbsId, final List<TempCartProductPack> packs, AccessWayEnum accessWay);
    List<TempCartProductPack> addPacks(final String binding, String tbsId, final List<TempCartProductPack> packs, AccessWayEnum accessWay,String channelCode);

    void removePacks(String binding, String tbsId, final Collection<TempCartProductPack> packs);

    void removePacksById(String binding, String tbsId, final Collection<Long> packIds);

    void removeByBinding(String binding);

    void removeByTbsId(String tbsId);

    /**
     * 清空失效商品
     *
     * @param binding
     */
    void clearInvalidPacks(final String binding, String tbsId, AccessWayEnum accessWay);

    /**
     * 修改临时购物车中的商品包。 若某商品包已存在临时购物车里，则修改之；若不存在，则加入之。
     *
     * @param binding
     * @param packs
     */
    @Deprecated
    List<TempCartProductPack> modifyPack(String binding, String tbsId, Collection<TempCartProductPack> packs, AccessWayEnum accessWay);
    /**
     * 修改临时购物车中的商品包。 若某商品包已存在临时购物车里，则修改之；若不存在，则加入之。
     *
     * @param binding
     * @param packs
     */
    List<TempCartProductPack> modifyPack(String binding, String tbsId, Collection<TempCartProductPack> packs, AccessWayEnum accessWay,String channelCode);
    /**
     * 将源商品包列表拆分为二，一个是有效的商品包列表，一个是无效的商品包列表，返回商品包和其商品（spv）的对应关系。
     * 无效列表中包括：商品包本身无效的、商品包有效但其商品无效的
     * 去除渠道参数  Channel channel
     * @param sourcePacks
     * @param validPacks
     * @param invalidPacks
     * @return
     */
    //Map<TempCartProductPack, PsSpvVO> separateInvalid(Collection<TempCartProductPack> sourcePacks, Collection<TempCartProductPack> validPacks, Collection<TempCartProductPack> invalidPacks);

}
