package com.thebeastshop.cart;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品包接口。 商品包是指若干个某种商品打成的包，共有2个主要属性：商品、数量。 “同一种”指的是spv（sku）
 *
 * @author Liang Wenjian
 */
public interface ProductPack {

    void setId(Long id);

    Long getSpvId();

    void setSpvId(Long spvId);

    PsSpvVO getSpv();

    void setSpv(PsSpvVO spv);

    Long getProductId();

    void setProductId(Long productId);

    PsProductVO getProduct();

    void setProduct(PsProductVO product);

    /**
     * 实际执行的商品价格。 比如加价购活动，实际执行的商品价格通常会跟商品的价格不一样。 TODO
     * 可能会产生不一致性，还是现算比较好。普通商品从sku表获得价格，加价购、赠品从活动表获得价格
     *
     * @return
     */
    BigDecimal getFactProductPrice();

    void setFactProductPrice(BigDecimal price);


    BigDecimal getPrice();

    /**
     * 是否额外获得的商品包，即并非用户自主要买的商品，包括赠品、加价购
     *
     * @return
     */
    CartPackSourceEnum getSource();

    void setSource(CartPackSourceEnum source);

    void setCount(int count);

    boolean isCustomize();

    List<CartCustomization> getCustomizeList();

    String getSourceBindVal();

    Integer getLimitCount();

    Date getCreateTime();

    boolean isValid();

    int getCount();

    Long getId();
}
