package com.thebeastshop.cart.resp;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by feilong.gao on 2016/12/13.
 */
public class CartCustomization implements Serializable {

    private static final long serialVersionUID = 2668575039896334980L;
    /**
     * id
     */
    private Long id;

    /**
     * 购物车id
     */
    private Long cartId;
    /**
     * 定制元素id
     */
    private String customDimensionId;
    /**
     * 定制元素名字
     */
    private String customDimensionName;
    /**
     * 定制维度值
     */
    private String customDimensionValue;

    /**
     * 创建时间
     */
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCartId() {
        return cartId;
    }

    public void setCartId(Long cartId) {
        this.cartId = cartId;
    }

    public String getCustomDimensionId() {
        return customDimensionId;
    }

    public void setCustomDimensionId(String customDimensionId) {
        this.customDimensionId = customDimensionId;
    }

    public String getCustomDimensionName() {
        return customDimensionName;
    }

    public void setCustomDimensionName(String customDimensionName) {
        this.customDimensionName = customDimensionName;
    }

    public String getCustomDimensionValue() {
        return customDimensionValue;
    }

    public void setCustomDimensionValue(String customDimensionValue) {
        this.customDimensionValue = customDimensionValue;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        String sb = "CartCustomization{" + "id=" + id +
                ", cartId=" + cartId +
                ", customDimensionId=" + customDimensionId +
                ", customDimensionName='" + customDimensionName + '\'' +
                ", customDimensionValue='" + customDimensionValue + '\'' +
                ", createTime=" + createTime +
                '}';
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CartCustomization that = (CartCustomization) o;

        if (customDimensionId != null ? !customDimensionId.equals(that.customDimensionId) : that.customDimensionId != null)
            return false;
        if (customDimensionName != null ? !customDimensionName.equals(that.customDimensionName) : that.customDimensionName != null)
            return false;
        return customDimensionValue != null ? customDimensionValue.equals(that.customDimensionValue) : that.customDimensionValue == null;

    }

    @Override
    public int hashCode() {
        int result = customDimensionId != null ? customDimensionId.hashCode() : 0;
        result = 31 * result + (customDimensionName != null ? customDimensionName.hashCode() : 0);
        result = 31 * result + (customDimensionValue != null ? customDimensionValue.hashCode() : 0);
        return result;
    }
}
