package com.thebeastshop.cart.resp;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.mark.HasOwner;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.cart.DeliveryVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 购物车-商品包关系。后面对应着一个表。
 *
 * @author Liang Wenjian
 */
public class CartProductPack implements ProductPack, HasOwner ,Serializable{

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	
	private Long id;
	private Long ownerId;
	private Long spvId;
	private PsSpvVO spv;
	private Long productId;
	private PsProductVO product;
	private BigDecimal factProductPrice;
	private BigDecimal customizePrice;
	private int count = 1;
	private int storeCount;
	private int warehouseCount;
    private List<DeliveryVO> deliverys;
	private CartPackSource source = CartPackSource.RAW;
	private boolean valid = true;
	private boolean isCustomize = false;
	private List<CartCustomization> customizeList;
	private List<CartProductPack> giftPacks;
	private Date createTime;
	private String sourceBindVal;
	private Integer limitCount;     // 赠品或换购商品总数

	public CartProductPack() {
		super();
	}

	public CartProductPack(ProductPack pack, Long ownerId) {
		super();
		this.setId(pack.getId());
		this.setCount(pack.getCount());
		this.setCreateTime(pack.getCreateTime());
		this.setFactProductPrice(pack.getFactProductPrice());
		this.setSource(pack.getSource());
		this.setSpvId(pack.getSpvId());
		this.setProductId(pack.getProductId());
		this.setValid(pack.isValid());
		this.setOwnerId(ownerId);
	}

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getSpvId() {
		return spvId;
	}

	public void setSpvId(final Long spvId) {
		this.spvId = spvId;
	}

	@Override
	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}

	public void setFactProductPrice(final BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}

	@Override
	public int getCount() {
		return count;
	}

	public void setCount(final int count) {
		this.count = count;
	}

	public int getStoreCount() {
		return storeCount;
	}

	public void setStoreCount(int storeCount) {
		this.storeCount = storeCount;
	}
	
	public int getWarehouseCount() {
		return warehouseCount;
	}

	public void setWarehouseCount(int warehouseCount) {
		this.warehouseCount = warehouseCount;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	@Override
	public CartPackSource getSource() {
		return source;
	}

	public void setSource(final CartPackSource source) {
		this.source = source;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}

	@Override
	public Long getOwnerId() {
		return ownerId;
	}

	@Override
	public BigDecimal getPrice() {
		return PriceUtil.multiPrice(getFactProductPrice(), getCount());
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
	}

	public Long getProductId() {
		return productId;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public PsSpvVO getSpv() {
		return spv;
	}

	public void setSpv(PsSpvVO spv) {
		this.spv = spv;
	}

	public PsProductVO getProduct() {
		return product;
	}

	public void setProduct(PsProductVO product) {
		this.product = product;
	}

	@Override
	public boolean isCustomize() {
		return isCustomize;
	}

	public void setCustomize(boolean customize) {
		isCustomize = customize;
	}

	@Override
	public List<CartCustomization> getCustomizeList() {
		return customizeList;
	}

	public void setCustomizeList(List<CartCustomization> customizeList) {
		this.customizeList = customizeList;
	}
	
	public List<CartProductPack> getGiftPacks() {
		return giftPacks;
	}

	public void setGiftPacks(List<CartProductPack> giftPacks) {
		this.giftPacks = giftPacks;
	}

	public BigDecimal getCustomizePrice() {
		return customizePrice;
	}

	public void setCustomizePrice(BigDecimal customizePrice) {
		this.customizePrice = customizePrice;
	}

	public String getSourceBindVal() {
		return sourceBindVal;
	}

	public void setSourceBindVal(String sourceBindVal) {
		this.sourceBindVal = sourceBindVal;
	}

    @Override
    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

	public List<DeliveryVO> getDeliverys() {
		return deliverys;
	}

	public void setDeliverys(List<DeliveryVO> deliverys) {
		this.deliverys = deliverys;
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

}
