/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.bi.dao.BiSkuForecastBaseInfMapper;
import com.thebeastshop.bi.dao.BiSkuSaleWhWeekDetailMapper;
import com.thebeastshop.bi.dto.BiSkuForecastDTO;
import com.thebeastshop.bi.dto.BiSkuForecastQueryDTO;
import com.thebeastshop.bi.dto.BiSkuSafetyStockDTO;
import com.thebeastshop.bi.dto.BiSkuSaleWhWeekDetailDTO;
import com.thebeastshop.bi.dto.BiSkuWeeklySalesDTO;
import com.thebeastshop.bi.po.BiSkuForecastBaseInf;
import com.thebeastshop.bi.po.BiSkuSaleWhWeekDetail;
import com.thebeastshop.bi.service.BiSkuForecastService;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="biSkuForecastService")
public class BiSkuForecastServiceImpl
implements BiSkuForecastService {
    @Autowired
    private BiSkuForecastBaseInfMapper biSkuForecastBaseInfMapper;
    @Autowired
    private BiSkuSaleWhWeekDetailMapper biSkuSaleWhWeekDetailMapper;

    public int batchInsertOrUpdateWeeklySales(List<BiSkuWeeklySalesDTO> skuWeeklySalesDTOList) {
        for (BiSkuWeeklySalesDTO skuWeeklySalesDTO : skuWeeklySalesDTOList) {
            skuWeeklySalesDTO.setSkuType("1");
            if (EmptyUtil.isEmpty((Object)skuWeeklySalesDTO.getOnlineRate())) {
                skuWeeklySalesDTO.setOnlineRate(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)skuWeeklySalesDTO.getOfflineRate())) continue;
            skuWeeklySalesDTO.setOfflineRate(BigDecimal.ZERO);
        }
        this.biSkuSaleWhWeekDetailMapper.batchInsertOrUpdate(BeanUtil.buildListFrom(skuWeeklySalesDTOList, BiSkuSaleWhWeekDetail.class));
        return 0;
    }

    public int batchInsertOrUpdateSafetyStock(List<BiSkuSafetyStockDTO> skuSafetyStockDTOList) {
        List list = BeanUtil.buildListFrom(skuSafetyStockDTOList, BiSkuForecastBaseInf.class);
        this.biSkuForecastBaseInfMapper.batchInsertOrUpdate(list);
        for (BiSkuSafetyStockDTO biSkuSafetyStockDTO : skuSafetyStockDTOList) {
        }
        return 0;
    }

    @Transactional
    public void importSkuSalesForecastData(List<BiSkuWeeklySalesDTO> skuWeeklySalesList, List<BiSkuSafetyStockDTO> skuSafetyStockList) throws Exception {
        this.batchInsertOrUpdateSafetyStock(skuSafetyStockList);
        this.batchInsertOrUpdateWeeklySales(skuWeeklySalesList);
    }

    public Map<String, Object> findSkuForecastByCond(BiSkuForecastQueryDTO queryCnd) {
        ArrayList<BiSkuSaleWhWeekDetailDTO> skuSaleWhWeekDetailDTOList;
        int offset = (queryCnd.getCurrpage() - 1) * queryCnd.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, queryCnd.getPagenum().intValue());
        HashSet<String> weekSet = new HashSet<String>();
        List biSkuForecastDTOList = this.biSkuForecastBaseInfMapper.findSkuForecastByCond(queryCnd, pageRowBounds);
        if (EmptyUtil.isNotEmpty((List)biSkuForecastDTOList)) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            for (BiSkuForecastDTO biSkuForecastDTO : biSkuForecastDTOList) {
                skuCodes.add(biSkuForecastDTO.getSkuCode());
            }
            List detailList = this.biSkuSaleWhWeekDetailMapper.findBiSkuSaleWhWeekDetailBySku(skuCodes, queryCnd.isHis(), String.valueOf(queryCnd.getSkuType()));
            for (BiSkuForecastDTO biSkuForecastDTO : biSkuForecastDTOList) {
                String skuCode = biSkuForecastDTO.getSkuCode();
                skuSaleWhWeekDetailDTOList = new ArrayList<BiSkuSaleWhWeekDetailDTO>();
                Iterator iterator = detailList.iterator();
                while (iterator.hasNext()) {
                    BiSkuSaleWhWeekDetailDTO detailDTO = (BiSkuSaleWhWeekDetailDTO)iterator.next();
                    Integer vYear = detailDTO.getvYear();
                    Double week = detailDTO.getWeek();
                    if (EmptyUtil.isNotEmpty((Object)vYear) && EmptyUtil.isNotEmpty((Object)week)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(String.valueOf(vYear));
                        stringBuffer.append(String.valueOf(week.intValue()));
                        weekSet.add(stringBuffer.toString());
                    }
                    if (!skuCode.equals(detailDTO.getSkuCode())) continue;
                    skuSaleWhWeekDetailDTOList.add(detailDTO);
                }
                biSkuForecastDTO.setSaleWhWeekDetailList(skuSaleWhWeekDetailDTOList);
            }
        }
        TreeSet<String> weekTreeSet = new TreeSet<String>((Comparator)((Object)(queryCnd.isHis() ? new DescOrderComparator() : new AscOrderComparator())));
        weekTreeSet.addAll(weekSet);
        for (BiSkuForecastDTO biSkuForecastDTO : biSkuForecastDTOList) {
            Iterator it = weekTreeSet.iterator();
            Integer yearWeekNum = weekTreeSet.size();
            skuSaleWhWeekDetailDTOList = new ArrayList(yearWeekNum);
            while (it.hasNext()) {
                String yearWeek = (String)it.next();
                BiSkuSaleWhWeekDetailDTO detail = new BiSkuSaleWhWeekDetailDTO();
                detail.setvYearWeek(yearWeek);
                detail.setOnlineRate(new BigDecimal(1));
                for (BiSkuSaleWhWeekDetailDTO detailDTO : biSkuForecastDTO.getSaleWhWeekDetailList()) {
                    if (!detailDTO.getvYearWeek().equals(yearWeek)) continue;
                    BeanUtils.copyProperties((Object)detailDTO, (Object)detail);
                }
                skuSaleWhWeekDetailDTOList.add(detail);
            }
            biSkuForecastDTO.setSaleWhWeekDetailList(skuSaleWhWeekDetailDTOList);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PageInfo pageInfo = new PageInfo(biSkuForecastDTOList);
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        resultMap.put("resultList", pageInfo);
        resultMap.put("weekSet", weekTreeSet);
        return resultMap;
    }

    public void saveAdjustItems(List<BiSkuSaleWhWeekDetailDTO> detailList) {
        ArrayList<BiSkuSaleWhWeekDetailDTO> newDetailList = new ArrayList<BiSkuSaleWhWeekDetailDTO>();
        if (EmptyUtil.isNotEmpty(detailList)) {
            for (BiSkuSaleWhWeekDetailDTO detailDTO : detailList) {
                if (!EmptyUtil.isNotEmpty((String)detailDTO.getSkuCode()) || !EmptyUtil.isNotEmpty((Object)detailDTO.getvYear()) || !EmptyUtil.isNotEmpty((Object)detailDTO.getWeek())) continue;
                newDetailList.add(detailDTO);
            }
        }
        this.biSkuSaleWhWeekDetailMapper.saveAdjustItems(newDetailList);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BiSkuForecastServiceImpl.this.biSkuForecastBaseInfMapper.excuteScSkuSafeWeekFuc();
            }
        }).start();
    }

    public int updateBySkuCode(BiSkuForecastDTO biSkuForecastDTO) {
        BiSkuForecastBaseInf po = new BiSkuForecastBaseInf();
        BeanUtils.copyProperties((Object)biSkuForecastDTO, (Object)po);
        return this.biSkuForecastBaseInfMapper.updateBySkuCode(po);
    }

    public int updateBySkuCodes(List<BiSkuForecastDTO> biSkuForecastList) {
        return 0;
    }

    private int getComparatorResult(Object o1, Object o2) {
        Integer year1 = Integer.valueOf(o1.toString().substring(0, 4));
        Integer month1 = Integer.valueOf(o1.toString().substring(4));
        Integer year2 = Integer.valueOf(o2.toString().substring(0, 4));
        Integer month2 = Integer.valueOf(o2.toString().substring(4));
        if (year1.equals(year2)) {
            if (month1 == month2) {
                return 0;
            }
            if (month1 > month2) {
                return -1;
            }
            return 1;
        }
        if (year1 < year2) {
            return 1;
        }
        if (year1 > year2) {
            return -1;
        }
        return 1;
    }

    class AscOrderComparator
    extends MyComparator
    implements Serializable {
        private static final long serialVersionUID = -3180092869517774501L;

        AscOrderComparator() {
        }
    }

    class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object o2, Object o1) {
            return BiSkuForecastServiceImpl.this.getComparatorResult(o1, o2);
        }
    }

    class DescOrderComparator
    extends OrderComparator
    implements Serializable {
        private static final long serialVersionUID = 7158363981234982392L;

        DescOrderComparator() {
        }
    }

    class OrderComparator
    implements Comparator {
        OrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            return BiSkuForecastServiceImpl.this.getComparatorResult(o1, o2);
        }
    }
}

