/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmcMessagesProduceResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmcMessagesProduceRequest
extends BaseTaobaoRequest<TmcMessagesProduceResponse> {
    private String messages;

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public void setMessages(List<TmcPublishMessage> messages) {
        this.messages = new JSONWriter(false, true).write(messages);
    }

    public String getMessages() {
        return this.messages;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.tmc.messages.produce";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("messages", this.messages);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmcMessagesProduceResponse> getResponseClass() {
        return TmcMessagesProduceResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.messages, 50, "messages");
    }

    public static class TmcPublishMessage
    extends TaobaoObject {
        private static final long serialVersionUID = 2221156695122225832L;
        @ApiField(value="content")
        private String content;
        @ApiField(value="json_ex_content")
        private String jsonExContent;
        @ApiField(value="target_app_key")
        private String targetAppKey;
        @ApiField(value="target_group")
        private String targetGroup;
        @ApiField(value="topic")
        private String topic;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getJsonExContent() {
            return this.jsonExContent;
        }

        public void setJsonExContent(String jsonExContent) {
            this.jsonExContent = jsonExContent;
        }

        public String getTargetAppKey() {
            return this.targetAppKey;
        }

        public void setTargetAppKey(String targetAppKey) {
            this.targetAppKey = targetAppKey;
        }

        public String getTargetGroup() {
            return this.targetGroup;
        }

        public void setTargetGroup(String targetGroup) {
            this.targetGroup = targetGroup;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }
    }
}

