/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel;

import com.taobao.api.internal.toplink.DefaultLoggerFactory;
import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.Pool;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.ClientChannelSelector;
import com.taobao.api.internal.toplink.channel.websocket.WebSocketClient;
import java.net.URI;
import java.util.Hashtable;

public class ClientChannelPooledSelector
implements ClientChannelSelector {
    private static final int CONNECT_TIMEOUT = 5000;
    private Hashtable<String, Pool<ClientChannel>> channels;
    private LoggerFactory loggerFactory;
    private Object lockObject;

    public ClientChannelPooledSelector() {
        this(DefaultLoggerFactory.getDefault());
    }

    public ClientChannelPooledSelector(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.channels = new Hashtable();
        this.lockObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientChannel getChannel(URI uri) throws ChannelException {
        String url = uri.toString();
        if (this.channels.get(url) == null) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.channels.get(url) == null) {
                    this.channels.put(url, this.createChannelPool(this.loggerFactory, uri, 5000));
                }
            }
        }
        try {
            return this.channels.get(url).chekOut();
        }
        catch (ChannelException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ChannelException(Text.GET_CHANNEL_ERROR, e);
        }
    }

    public void returnChannel(ClientChannel channel) {
        this.channels.get(channel.getUri().toString()).checkIn(channel);
    }

    protected ChannelPool createChannelPool(LoggerFactory loggerFactory, URI uri, int timeout) {
        return new ChannelPool(loggerFactory, uri, timeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChannelPool
    extends Pool<ClientChannel> {
        protected LoggerFactory loggerFactory;
        protected URI uri;
        protected int timeout;

        public ChannelPool(LoggerFactory loggerFactory, URI uri, int timeout) {
            super(50, 10);
            this.loggerFactory = loggerFactory;
            this.uri = uri;
            this.timeout = timeout;
        }

        @Override
        public ClientChannel chekOut() throws Throwable {
            ClientChannel channel = (ClientChannel)super.chekOut();
            if (channel == null) {
                throw new ChannelException(Text.RPC_POOL_BUSY);
            }
            return channel;
        }

        @Override
        public ClientChannel create() throws ChannelException {
            return WebSocketClient.connect(this.loggerFactory, this.uri, this.timeout);
        }

        @Override
        public boolean validate(ClientChannel t) {
            return t.isConnected();
        }
    }
}

