/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import com.taobao.api.internal.tmc.Message;
import com.taobao.api.internal.tmc.MessageKind;
import com.taobao.api.internal.tmc.TmcClient;
import com.taobao.api.internal.tmc.TmcIdentity;
import com.taobao.api.internal.toplink.LinkException;
import com.taobao.api.internal.util.BooleanUtils;
import com.taobao.api.internal.util.NamedThreadFactory;
import com.taobao.api.internal.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TmcPullClient
extends TmcClient {
    private static final Log log = LogFactory.getLog(TmcPullClient.class);
    private static final String PULL_MODE = "pull_mode";
    private static final int DEFAULT_QPS_RATE = 32;
    private final RateLimiter rateLimiter = RateLimiter.create(32.0);
    private volatile int curQpsRate = 32;
    private volatile int queueLogicSize;
    public static final int STOP_PULL_THRESHOLD = 32;
    private static final int CONFIRM_TIMEOUT = 30;
    private ScheduledExecutorService pullService;

    public TmcPullClient(String uri, String appKey, String appSecret, String groupName, String minorGroup, String filterExp) {
        super(uri, appKey, appSecret, groupName, minorGroup, filterExp);
        this.updateQueueLogicSize(this.curQpsRate);
    }

    public void setQueueSize(int queueSize) {
        int minQueueSize = 34;
        if (queueSize < minQueueSize) {
            throw new IllegalArgumentException("queue size must greater than " + minQueueSize);
        }
        super.setQueueSize(queueSize);
        this.updateQueueLogicSize(this.curQpsRate);
    }

    protected TmcClient.InnerClient createInnerClient(TmcIdentity id) {
        return new InnerPullClient(id);
    }

    protected void beforeSubmitMsgToQueue(Message message) {
        super.beforeSubmitMsgToQueue(message);
        Map<String, Object> rawMsg = message.getRaw();
        Integer qpsRate = (Integer)rawMsg.get("qpsRate");
        if (qpsRate != null) {
            this.updateQpsRateIfChange(qpsRate);
        }
    }

    protected void afterRetrieveMsgFromQueue() {
        super.afterRetrieveMsgFromQueue();
        this.rateLimiter.acquire();
    }

    protected void pullRequest() {
    }

    protected synchronized void onClose() {
        super.onClose();
        if (this.pullService != null) {
            this.pullService.shutdown();
        }
    }

    private int clampQueueLogicSize(int newQueueLogicSize) {
        return Math.max(Math.min(newQueueLogicSize, (int)Math.ceil((double)this.getQueueSize() * 0.8) - 1), 33);
    }

    private void updateQueueLogicSize(int qpsRate) {
        int newQueueLogicSize = (int)Math.ceil((double)(qpsRate * 30) * 0.8);
        this.queueLogicSize = this.clampQueueLogicSize(newQueueLogicSize);
    }

    private synchronized void updateQpsRateIfChange(int qpsRate) {
        if (qpsRate > 0 && this.curQpsRate != qpsRate) {
            this.curQpsRate = qpsRate;
            this.rateLimiter.setRate(qpsRate);
            this.updateQueueLogicSize(qpsRate);
        }
    }

    public int getLogicRemainCapacity() {
        return this.queueLogicSize - this.getThreadPool().getQueue().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerPullClient
    extends TmcClient.InnerClient {
        public InnerPullClient(TmcIdentity id) {
            super(TmcPullClient.this, id);
        }

        @Override
        protected Map<String, Object> createConnectHeaders() throws LinkException {
            Map<String, Object> connectHeaders = super.createConnectHeaders();
            connectHeaders.put(TmcPullClient.PULL_MODE, BooleanUtils.convertToFlag(true));
            return connectHeaders;
        }

        @Override
        protected synchronized void onConnectSuccess() {
            super.onConnectSuccess();
            if (TmcPullClient.this.pullService != null) {
                TmcPullClient.this.pullService.shutdown();
            }
            TmcPullClient.this.pullService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("pull-service", true));
            TmcPullClient.this.pullService.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    try {
                        int remainCapacity = TmcPullClient.this.getLogicRemainCapacity();
                        if (remainCapacity < 32) {
                            return;
                        }
                        HashMap<String, Object> pullRequest = new HashMap<String, Object>();
                        pullRequest.put("__kind", MessageKind.PullRequest);
                        pullRequest.put("cap", remainCapacity);
                        TmcClient.InnerClient innerClient = TmcPullClient.this.getClient();
                        if (innerClient != null && innerClient.isOnline()) {
                            innerClient.send(pullRequest);
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)"pull error", e);
                    }
                }
            }, 200L, 200L, TimeUnit.MILLISECONDS);
        }
    }
}

