/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.report;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.internal.report.TopSdkFeedbackUploadRequest;
import com.taobao.api.internal.report.TopSdkFeedbackUploadResponse;
import com.taobao.api.internal.util.LruHashMap;
import com.taobao.api.security.Counter;
import com.taobao.api.security.SecurityCore;
import com.taobao.api.security.SecurityCounter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiReporter {
    private static final long SLEEP_TIME = 60000L;
    private static final Log LOG = LogFactory.getLog(ApiReporter.class);
    private static final long FLUSH_INTERVAL = 300000L;
    private static final long MIN_FLUSH_INTERVAL = 60000L;
    private static final String APP_SECRET_TYPE = "2";
    private static final String APP_USER_SECRET_TYPE = "3";
    private DefaultTaobaoClient defaultTaobaoClient;
    private static final Object LOCK = new Object();
    private static final Set<String> APP_SET = new HashSet<String>();
    private static boolean stopApiReporter;
    private static Thread currentThread;
    private static boolean enableApiReporter;

    public static void shutdown() {
        if (!enableApiReporter) {
            return;
        }
        stopApiReporter = true;
        currentThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSecret(DefaultTaobaoClient defaultTaobaoClient) {
        String appkey = defaultTaobaoClient.getAppKey();
        if (APP_SET.contains(appkey)) {
            return;
        }
        enableApiReporter = defaultTaobaoClient.isEnableApiReporter();
        if (!enableApiReporter) {
            return;
        }
        this.defaultTaobaoClient = defaultTaobaoClient;
        Object object = LOCK;
        synchronized (object) {
            if (APP_SET.contains(appkey)) {
                return;
            }
            this.initSecretThread();
            APP_SET.add(appkey);
        }
    }

    @Deprecated
    private void initSecretThread() {
        currentThread = new Thread("flushSecretApiReporter-thread"){

            public void run() {
                ApiReporter.this.doUploadBiz();
            }
        };
        currentThread.start();
    }

    private void doUploadBiz() {
        long uploadTime = System.currentTimeMillis() + 300000L;
        while (!stopApiReporter) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"interrupted flushSecretApiReporter ", (Throwable)e);
                if (stopApiReporter) break;
            }
            try {
                LruHashMap<String, Counter> appUserCounterMap = SecurityCounter.getUserCounterMap(this.defaultTaobaoClient.getAppKey());
                if (System.currentTimeMillis() < uploadTime && appUserCounterMap.size() * 4 <= appUserCounterMap.getMaxCapacity()) continue;
                StringBuilder counterBuilder = new StringBuilder();
                Map<String, Counter> cloneAppUserCounter = appUserCounterMap.cloneEntry();
                SecurityCounter.cleanUserCounter(this.defaultTaobaoClient.getAppKey());
                int count = 0;
                for (Map.Entry<String, Counter> entry : cloneAppUserCounter.entrySet()) {
                    Counter counter = entry.getValue();
                    if (counterBuilder.length() > 0) {
                        counterBuilder.append(";");
                    }
                    counterBuilder.append(entry.getKey());
                    this.generateCounter(counterBuilder, counter);
                    if (++count % 100 != 0) continue;
                    this.doUpload(counterBuilder.toString(), APP_USER_SECRET_TYPE);
                    counterBuilder = new StringBuilder();
                }
                if (counterBuilder.length() > 0) {
                    this.doUpload(counterBuilder.toString(), APP_USER_SECRET_TYPE);
                    counterBuilder = new StringBuilder();
                }
                Counter counter = SecurityCounter.getAppCounter(this.defaultTaobaoClient.getAppKey());
                counterBuilder.append(SecurityCore.getAppUserSecretCache().size());
                this.generateCounter(counterBuilder, counter);
                counter.reset();
                long uploadInterval = this.doUpload(counterBuilder.toString(), APP_SECRET_TYPE);
                uploadTime = System.currentTimeMillis() + uploadInterval;
            }
            catch (Throwable e) {
                LOG.error((Object)"flushSecretApiReporter error", e);
            }
        }
    }

    private long doUpload(String contentJson, String type) throws ApiException {
        long uploadInterval = 300000L;
        TopSdkFeedbackUploadRequest request = new TopSdkFeedbackUploadRequest();
        request.setType(type);
        request.setContent(contentJson);
        TopSdkFeedbackUploadResponse response = this.defaultTaobaoClient.execute(request, null);
        if (response.isSuccess() && (uploadInterval = response.getUploadInterval()) < 60000L) {
            uploadInterval = 300000L;
        }
        return uploadInterval;
    }

    private void generateCounter(StringBuilder counterBuilder, Counter counter) {
        if (counterBuilder.length() > 0) {
            counterBuilder.append(",");
        }
        if (SecurityCounter.getAppCounter(this.defaultTaobaoClient.getAppKey()).getEncryptPhoneNum().get() != 0L) {
            counterBuilder.append(counter.getEncryptPhoneNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getEncryptNickNum().get() != 0L) {
            counterBuilder.append(counter.getEncryptNickNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getEncryptReceiverNameNum().get() != 0L) {
            counterBuilder.append(counter.getEncryptReceiverNameNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getEncryptSimpleNum().get() != 0L) {
            counterBuilder.append(counter.getEncryptSimpleNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getEncryptSearchNum().get() != 0L) {
            counterBuilder.append(counter.getEncryptSearchNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getDecryptPhoneNum().get() != 0L) {
            counterBuilder.append(counter.getDecryptPhoneNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getDecryptNickNum().get() != 0L) {
            counterBuilder.append(counter.getDecryptNickNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getDecryptReceiverNameNum().get() != 0L) {
            counterBuilder.append(counter.getDecryptReceiverNameNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getDecryptSimpleNum().get() != 0L) {
            counterBuilder.append(counter.getDecryptSimpleNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getDecryptSearchNum().get() != 0L) {
            counterBuilder.append(counter.getDecryptSearchNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getSearchPhoneNum().get() != 0L) {
            counterBuilder.append(counter.getSearchPhoneNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getSearchNickNum().get() != 0L) {
            counterBuilder.append(counter.getSearchNickNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getSearchReceiverNameNum().get() != 0L) {
            counterBuilder.append(counter.getSearchReceiverNameNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getSearchSimpleNum().get() != 0L) {
            counterBuilder.append(counter.getSearchSimpleNum());
        } else {
            this.appendZero(counterBuilder);
        }
        counterBuilder.append(",");
        if (counter.getSearchSearchNum().get() != 0L) {
            counterBuilder.append(counter.getSearchSearchNum());
        } else {
            this.appendZero(counterBuilder);
        }
    }

    private void appendZero(StringBuilder counterBuilder) {
        counterBuilder.append("0");
    }

    static {
        enableApiReporter = false;
    }
}

