/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.RegionPriceManageResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionPriceManageRequest
extends BaseTaobaoRequest<RegionPriceManageResponse> {
    private Boolean isFull;
    private Long itemId;
    private String regionalPriceDtos;
    private Long skuId;

    public void setIsFull(Boolean isFull) {
        this.isFull = isFull;
    }

    public Boolean getIsFull() {
        return this.isFull;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setRegionalPriceDtos(String regionalPriceDtos) {
        this.regionalPriceDtos = regionalPriceDtos;
    }

    public void setRegionalPriceDtos(List<RegionalPriceDto> regionalPriceDtos) {
        this.regionalPriceDtos = new JSONWriter(false, true).write(regionalPriceDtos);
    }

    public String getRegionalPriceDtos() {
        return this.regionalPriceDtos;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.region.price.manage";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("is_full", (Object)this.isFull);
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("regional_price_dtos", this.regionalPriceDtos);
        txtParams.put("sku_id", (Object)this.skuId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<RegionPriceManageResponse> getResponseClass() {
        return RegionPriceManageResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.regionalPriceDtos, 20, "regionalPriceDtos");
    }

    public static class RegionalPriceDto
    extends TaobaoObject {
        private static final long serialVersionUID = 5137749768246633582L;
        @ApiField(value="city")
        private String city;
        @ApiField(value="price")
        private Long price;
        @ApiField(value="province")
        private String province;

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public Long getPrice() {
            return this.price;
        }

        public void setPrice(Long price) {
            this.price = price;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }
    }
}

