/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LocationRelationEditResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationRelationEditRequest
extends BaseTaobaoRequest<LocationRelationEditResponse> {
    private String locationRelationList;

    public void setLocationRelationList(String locationRelationList) {
        this.locationRelationList = locationRelationList;
    }

    public void setLocationRelationList(List<LocationRelationDto> locationRelationList) {
        this.locationRelationList = new JSONWriter(false, true).write(locationRelationList);
    }

    public String getLocationRelationList() {
        return this.locationRelationList;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.location.relation.edit";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("location_relation_list", this.locationRelationList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<LocationRelationEditResponse> getResponseClass() {
        return LocationRelationEditResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.locationRelationList, 20, "locationRelationList");
    }

    public static class LocationRelationDto
    extends TaobaoObject {
        private static final long serialVersionUID = 6266342442958573882L;
        @ApiField(value="source_inv_store_type")
        private Long sourceInvStoreType;
        @ApiField(value="source_store_code")
        private String sourceStoreCode;
        @ApiField(value="status")
        private Long status;
        @ApiField(value="target_inv_store_type")
        private Long targetInvStoreType;
        @ApiField(value="target_store_code")
        private String targetStoreCode;

        public Long getSourceInvStoreType() {
            return this.sourceInvStoreType;
        }

        public void setSourceInvStoreType(Long sourceInvStoreType) {
            this.sourceInvStoreType = sourceInvStoreType;
        }

        public String getSourceStoreCode() {
            return this.sourceStoreCode;
        }

        public void setSourceStoreCode(String sourceStoreCode) {
            this.sourceStoreCode = sourceStoreCode;
        }

        public Long getStatus() {
            return this.status;
        }

        public void setStatus(Long status) {
            this.status = status;
        }

        public Long getTargetInvStoreType() {
            return this.targetInvStoreType;
        }

        public void setTargetInvStoreType(Long targetInvStoreType) {
            this.targetInvStoreType = targetInvStoreType;
        }

        public String getTargetStoreCode() {
            return this.targetStoreCode;
        }

        public void setTargetStoreCode(String targetStoreCode) {
            this.targetStoreCode = targetStoreCode;
        }
    }
}

