/*
 * Decompiled with CFR 0.152.
 */
package com.jd.open.api.sdk.internal.parser;

import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.jd.open.api.sdk.internal.parser.Parser;
import com.jd.open.api.sdk.internal.util.StringUtil;
import com.jd.open.api.sdk.response.AbstractResponse;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser
implements Parser {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonParser() {
        this.mapper.getDeserializationConfig().set(DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        this.mapper.getDeserializationConfig().set(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public <T extends AbstractResponse> T parse(String json, Class<T> responseClass) throws JdException {
        AbstractResponse response = null;
        try {
            if (StringUtil.isEmpty(json)) {
                throw new JdException("response json is empty!");
            }
            response = (AbstractResponse)this.fromJson(json, responseClass);
            if (response != null) {
                response.setMsg(json);
            }
        }
        catch (Exception e) {
            throw new JdException(e);
        }
        return (T)response;
    }

    public <T extends AbstractResponse> T fromJson(String json, Class<T> responseClass) throws Exception {
        ObjectNode rootNode = null;
        try {
            rootNode = (ObjectNode)this.mapper.readTree(json);
        }
        catch (Exception e) {
            rootNode = (ObjectNode)this.mapper.readTree(JSON.toString(JSON.parse(json)));
        }
        String innerJson = ((JsonNode)((Map.Entry)rootNode.getFields().next()).getValue()).toString();
        return (T)((AbstractResponse)this.mapper.readValue(innerJson, responseClass));
    }
}

