/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.system;

import com.dianping.cat.status.AbstractCollector;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProcessorInfoCollector
extends AbstractCollector {
    private long lastProcessCputime = 0L;

    private static boolean isSunOsMBean(java.lang.management.OperatingSystemMXBean operatingSystem) {
        String className = operatingSystem.getClass().getName();
        return "com.sun.management.OperatingSystem".equals(className) || "com.sun.management.UnixOperatingSystem".equals(className);
    }

    private Map<String, Number> doProcessCollect() {
        OperatingSystemMXBean osBean;
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        java.lang.management.OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        map.put("system.load.average", operatingSystem.getSystemLoadAverage());
        if (operatingSystem instanceof OperatingSystemMXBean) {
            osBean = (OperatingSystemMXBean)operatingSystem;
            map.put("cpu.system.load.percent", osBean.getSystemCpuLoad() * 100.0);
            map.put("cpu.jvm.load.percent", osBean.getProcessCpuLoad() * 100.0);
            map.put("system.process.used.phyical.memory", osBean.getTotalPhysicalMemorySize() - osBean.getFreePhysicalMemorySize());
            map.put("system.process.used.swap.size", osBean.getTotalSwapSpaceSize() - osBean.getFreeSwapSpaceSize());
        }
        if (ProcessorInfoCollector.isSunOsMBean(operatingSystem)) {
            if (operatingSystem instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unixOsBean = (UnixOperatingSystemMXBean)operatingSystem;
                try {
                    map.put("jvm.process.filedescriptors", unixOsBean.getOpenFileDescriptorCount());
                }
                catch (Error e) {
                    // empty catch block
                }
            }
            osBean = (OperatingSystemMXBean)operatingSystem;
            long processCpuTime = osBean.getProcessCpuTime() / 1000000L;
            map.put("jvm.process.cputime", processCpuTime - this.lastProcessCputime);
            this.lastProcessCputime = processCpuTime;
        }
        return map;
    }

    @Override
    public String getId() {
        return "system.process";
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, Number> map = this.doProcessCollect();
        return this.convert(map);
    }
}

