/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.send;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class HttpSendConfig {
    public static final String DFT_CONFIG_FILE_NAME = "jmonitor.properties";
    public static final String MULTI_PROPS_SEPERATOR = ",";
    public static HttpSendConfig m_config;
    private String m_endpoint;
    private String m_tag;
    private int m_step;
    private String m_url;
    private int m_maxItemHold;
    private boolean m_disabled;

    public static synchronized HttpSendConfig loadDefaultConfig() {
        if (m_config == null) {
            String filename = DFT_CONFIG_FILE_NAME;
            Properties props = new Properties();
            InputStream is = HttpSendConfig.class.getClassLoader().getResourceAsStream(filename);
            if (is == null) {
                is = HttpSendConfig.class.getClassLoader().getResourceAsStream("http-config-dft.properties");
            }
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Http config failed to read " + filename, e);
            }
            m_config = new HttpSendConfig(props);
        }
        return m_config;
    }

    private HttpSendConfig(Properties props) {
        this.m_disabled = Boolean.parseBoolean(props.getProperty("disabled", "false"));
        if (this.m_disabled) {
            return;
        }
        this.m_endpoint = props.getProperty("falcon.endpoint", this.getLocalHostName());
        this.m_tag = props.getProperty("http.agent.tag", "");
        this.m_step = Integer.parseInt(props.getProperty("http.agent.step", "60"));
        this.m_url = props.getProperty("http.agent.url", "http://127.0.0.1:1988/v1/push");
        this.m_maxItemHold = Integer.parseInt(props.getProperty("max-item-hold", "8192"));
    }

    public String getEndpoint() {
        return this.m_endpoint;
    }

    private String getLocalHostName() {
        String hostname = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        if (hostname == null) {
            hostname = "unkown";
        } else if (hostname.contains(".sankuai.com") || hostname.contains(".office.mos")) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        return hostname;
    }

    public int getMaxItemHold() {
        return this.m_maxItemHold;
    }

    public int getStep() {
        return this.m_step;
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getUrl() {
        return this.m_url;
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    public void setDisabled(boolean disabled) {
        this.m_disabled = disabled;
    }

    public void setEndpoint(String endpoint) {
        this.m_endpoint = endpoint;
    }

    public void setMaxItemHold(int maxItemHold) {
        this.m_maxItemHold = maxItemHold;
    }

    public void setStep(int step) {
        this.m_step = step;
    }

    public void setTag(String tag) {
        this.m_tag = tag;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }
}

