/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.send;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.status.send.HttpSendConfig;
import com.dianping.cat.status.send.SendLocalAgentException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.unidal.lookup.util.StringUtils;

public class HttpAgentSender {
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int MAX_SEND_ITEM_PER_WRITE = 1024;
    private static final int SOCKET_TIMEOUT = 1000;
    private long m_interval = 60000L;
    private BlockingQueue<Item> m_queue = new ArrayBlockingQueue<Item>(8192);
    private final HttpSendConfig m_config;
    private Thread m_thread;
    private volatile boolean m_running = true;
    private int m_errorCount;
    private static HttpAgentSender m_sender;

    public static synchronized HttpAgentSender getInstance(HttpSendConfig config) {
        if (m_sender == null) {
            m_sender = new HttpAgentSender(config);
        }
        return m_sender;
    }

    private HttpAgentSender(HttpSendConfig config) {
        this.m_config = config;
    }

    public void asyncSend(String key, String value, long mills) {
        boolean r = this.m_queue.offer(new Item(key, value, mills));
        if (!r) {
            if (this.m_errorCount++ % 1000 == 0) {
                Cat.logError(new SendLocalAgentException("error when offer metric to http agent queue , queue is full"));
            }
            for (int i = 0; i < 4096; ++i) {
                this.m_queue.poll();
            }
        }
    }

    private String buildPostParam(List<Item> list) {
        StringBuilder data = new StringBuilder();
        String tag = this.m_config.getTag();
        int step = this.m_config.getStep();
        data.append("[");
        for (Item item : list) {
            String key = item.m_key;
            if (StringUtils.isEmpty((String)key)) continue;
            data.append("{");
            data.append("\"endpoint\":\"").append(this.m_config.getEndpoint()).append("\",");
            data.append("\"metric\":\"").append(key).append("\",");
            data.append("\"value\":\"").append(item.m_value).append("\",");
            data.append("\"timestamp\":").append(item.m_mills / 1000L).append(",");
            data.append("\"step\":").append(step).append(",");
            data.append("\"counterType\":\"").append("GAUGE").append("\",");
            data.append("\"tags\":\"").append(tag).append("\"");
            data.append("},");
        }
        data.deleteCharAt(data.length() - 1);
        data.append("]\n");
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHttpPost(List<Item> list) {
        URL url = null;
        PrintWriter out = null;
        boolean r = true;
        HttpURLConnection conn = null;
        try {
            url = new URL(this.m_config.getUrl());
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.connect();
            out = new PrintWriter(conn.getOutputStream());
            String body = this.buildPostParam(list);
            out.write(body);
            out.flush();
            int code = conn.getResponseCode();
            if (code > 300) {
                Cat.logError(new SendLocalAgentException("error when send local agent with code " + code));
            }
        }
        catch (Exception e) {
            Cat.logEvent("UnknownHttpAgent", NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            r = false;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        if (!r) {
            for (Item item : list) {
                this.m_queue.offer(item);
            }
        }
        return r;
    }

    public void initWorkThread() {
        this.m_thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: while (true) {
                    try {
                        while (HttpAgentSender.this.m_running && !Thread.currentThread().isInterrupted()) {
                            long elapsed;
                            long start = System.currentTimeMillis();
                            if (null != HttpAgentSender.this.m_queue.peek()) {
                                try {
                                    Item item;
                                    ArrayList<Item> list = new ArrayList<Item>();
                                    for (int i = 0; i < HttpAgentSender.this.m_config.getMaxItemHold() && null != (item = (Item)HttpAgentSender.this.m_queue.poll()); ++i) {
                                        list.add(item);
                                        if (list.size() < 1024) continue;
                                        HttpAgentSender.this.doHttpPost(list);
                                        list.clear();
                                    }
                                    if (!list.isEmpty()) {
                                        HttpAgentSender.this.doHttpPost(list);
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if ((elapsed = System.currentTimeMillis() - start) >= HttpAgentSender.this.m_interval) continue;
                            try {
                                Thread.sleep(HttpAgentSender.this.m_interval - elapsed);
                                continue block6;
                            }
                            catch (InterruptedException e) {
                                break block6;
                            }
                        }
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
            }
        });
        this.m_thread.setName("cat-local-http-send");
        this.m_thread.setDaemon(true);
        this.m_running = true;
        this.m_thread.start();
    }

    private static class Item {
        private String m_key;
        private String m_value;
        private long m_mills;

        private Item(String key, String value, long mills) {
            this.m_key = key;
            this.m_value = value;
            this.m_mills = mills;
        }
    }
}

