/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;
import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.DiskInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.MemoryInfo;
import com.dianping.cat.status.model.entity.MessageInfo;
import com.dianping.cat.status.model.entity.OsInfo;
import com.dianping.cat.status.model.entity.RuntimeInfo;
import com.dianping.cat.status.model.entity.ThreadsInfo;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatusInfo
extends BaseEntity<StatusInfo> {
    private Date m_timestamp;
    private RuntimeInfo m_runtime;
    private OsInfo m_os;
    private DiskInfo m_disk;
    private MemoryInfo m_memory;
    private ThreadsInfo m_thread;
    private MessageInfo m_message;
    private Map<String, Extension> m_extensions = new LinkedHashMap<String, Extension>();
    private Map<String, CustomInfo> m_customInfos = new LinkedHashMap<String, CustomInfo>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitStatus(this);
    }

    public StatusInfo addCustomInfo(CustomInfo customInfo) {
        this.m_customInfos.put(customInfo.getKey(), customInfo);
        return this;
    }

    public StatusInfo addExtension(Extension extension) {
        this.m_extensions.put(extension.getId(), extension);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatusInfo) {
            StatusInfo _o = (StatusInfo)obj;
            Date timestamp = _o.getTimestamp();
            RuntimeInfo runtime = _o.getRuntime();
            OsInfo os = _o.getOs();
            DiskInfo disk = _o.getDisk();
            MemoryInfo memory = _o.getMemory();
            ThreadsInfo thread = _o.getThread();
            MessageInfo message = _o.getMessage();
            Map<String, Extension> extensions = _o.getExtensions();
            Map<String, CustomInfo> customInfos = _o.getCustomInfos();
            boolean result = true;
            result &= this.m_timestamp == timestamp || this.m_timestamp != null && this.m_timestamp.equals(timestamp);
            result &= this.m_runtime == runtime || this.m_runtime != null && this.m_runtime.equals(runtime);
            result &= this.m_os == os || this.m_os != null && this.m_os.equals(os);
            result &= this.m_disk == disk || this.m_disk != null && this.m_disk.equals(disk);
            result &= this.m_memory == memory || this.m_memory != null && this.m_memory.equals(memory);
            result &= this.m_thread == thread || this.m_thread != null && this.m_thread.equals(thread);
            result &= this.m_message == message || this.m_message != null && this.m_message.equals(message);
            result &= this.m_extensions == extensions || this.m_extensions != null && this.m_extensions.equals(extensions);
            return result &= this.m_customInfos == customInfos || this.m_customInfos != null && this.m_customInfos.equals(customInfos);
        }
        return false;
    }

    public CustomInfo findCustomInfo(String key) {
        return this.m_customInfos.get(key);
    }

    public Extension findExtension(String id) {
        return this.m_extensions.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomInfo findOrCreateCustomInfo(String key) {
        CustomInfo customInfo = this.m_customInfos.get(key);
        if (customInfo == null) {
            Map<String, CustomInfo> map = this.m_customInfos;
            synchronized (map) {
                customInfo = this.m_customInfos.get(key);
                if (customInfo == null) {
                    customInfo = new CustomInfo(key);
                    this.m_customInfos.put(key, customInfo);
                }
            }
        }
        return customInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension findOrCreateExtension(String id) {
        Extension extension = this.m_extensions.get(id);
        if (extension == null) {
            Map<String, Extension> map = this.m_extensions;
            synchronized (map) {
                extension = this.m_extensions.get(id);
                if (extension == null) {
                    extension = new Extension(id);
                    this.m_extensions.put(id, extension);
                }
            }
        }
        return extension;
    }

    public Map<String, CustomInfo> getCustomInfos() {
        return this.m_customInfos;
    }

    public DiskInfo getDisk() {
        return this.m_disk;
    }

    public Map<String, Extension> getExtensions() {
        return this.m_extensions;
    }

    public MemoryInfo getMemory() {
        return this.m_memory;
    }

    public MessageInfo getMessage() {
        return this.m_message;
    }

    public OsInfo getOs() {
        return this.m_os;
    }

    public RuntimeInfo getRuntime() {
        return this.m_runtime;
    }

    public ThreadsInfo getThread() {
        return this.m_thread;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_timestamp == null ? 0 : this.m_timestamp.hashCode());
        hash = hash * 31 + (this.m_runtime == null ? 0 : this.m_runtime.hashCode());
        hash = hash * 31 + (this.m_os == null ? 0 : this.m_os.hashCode());
        hash = hash * 31 + (this.m_disk == null ? 0 : this.m_disk.hashCode());
        hash = hash * 31 + (this.m_memory == null ? 0 : this.m_memory.hashCode());
        hash = hash * 31 + (this.m_thread == null ? 0 : this.m_thread.hashCode());
        hash = hash * 31 + (this.m_message == null ? 0 : this.m_message.hashCode());
        hash = hash * 31 + (this.m_extensions == null ? 0 : this.m_extensions.hashCode());
        hash = hash * 31 + (this.m_customInfos == null ? 0 : this.m_customInfos.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(StatusInfo other) {
        if (other.getTimestamp() != null) {
            this.m_timestamp = other.getTimestamp();
        }
    }

    public boolean removeCustomInfo(String key) {
        if (this.m_customInfos.containsKey(key)) {
            this.m_customInfos.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeExtension(String id) {
        if (this.m_extensions.containsKey(id)) {
            this.m_extensions.remove(id);
            return true;
        }
        return false;
    }

    public StatusInfo setDisk(DiskInfo disk) {
        this.m_disk = disk;
        return this;
    }

    public StatusInfo setMemory(MemoryInfo memory) {
        this.m_memory = memory;
        return this;
    }

    public StatusInfo setMessage(MessageInfo message) {
        this.m_message = message;
        return this;
    }

    public StatusInfo setOs(OsInfo os) {
        this.m_os = os;
        return this;
    }

    public StatusInfo setRuntime(RuntimeInfo runtime) {
        this.m_runtime = runtime;
        return this;
    }

    public StatusInfo setThread(ThreadsInfo thread) {
        this.m_thread = thread;
        return this;
    }

    public StatusInfo setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
        return this;
    }
}

