/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;
import com.dianping.cat.status.model.entity.ExtensionDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class Extension
extends BaseEntity<Extension> {
    private String m_id;
    private String m_description;
    private Map<String, ExtensionDetail> m_details = new LinkedHashMap<String, ExtensionDetail>();
    private Map<String, String> m_dynamicAttributes = new LinkedHashMap<String, String>();

    public Extension() {
    }

    public Extension(String id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitExtension(this);
    }

    public Extension addExtensionDetail(ExtensionDetail extensionDetail) {
        this.m_details.put(extensionDetail.getId(), extensionDetail);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Extension) {
            Extension _o = (Extension)obj;
            String id = _o.getId();
            return this.m_id == id || this.m_id != null && this.m_id.equals(id);
        }
        return false;
    }

    public ExtensionDetail findExtensionDetail(String id) {
        return this.m_details.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionDetail findOrCreateExtensionDetail(String id) {
        ExtensionDetail extensionDetail = this.m_details.get(id);
        if (extensionDetail == null) {
            Map<String, ExtensionDetail> map = this.m_details;
            synchronized (map) {
                extensionDetail = this.m_details.get(id);
                if (extensionDetail == null) {
                    extensionDetail = new ExtensionDetail(id);
                    this.m_details.put(id, extensionDetail);
                }
            }
        }
        return extensionDetail;
    }

    public String getDynamicAttribute(String name) {
        return this.m_dynamicAttributes.get(name);
    }

    public Map<String, String> getDynamicAttributes() {
        return this.m_dynamicAttributes;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Map<String, ExtensionDetail> getDetails() {
        return this.m_details;
    }

    public String getId() {
        return this.m_id;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(Extension other) {
        this.assertAttributeEquals(other, "extension", "id", this.m_id, other.getId());
        for (Map.Entry<String, String> e : other.getDynamicAttributes().entrySet()) {
            this.m_dynamicAttributes.put(e.getKey(), e.getValue());
        }
    }

    public boolean removeExtensionDetail(String id) {
        if (this.m_details.containsKey(id)) {
            this.m_details.remove(id);
            return true;
        }
        return false;
    }

    public void setDynamicAttribute(String name, String value) {
        this.m_dynamicAttributes.put(name, value);
    }

    public Extension setDescription(String description) {
        this.m_description = description;
        return this;
    }

    public Extension setId(String id) {
        this.m_id = id;
        return this;
    }
}

