/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MemoryInformations {
    private final long m_usedMemory;
    private final long m_maxMemory;
    private final long m_usedOldGen;
    private final long m_maxOldGen;
    private final long m_usedPermGen;
    private final long m_maxPermGen;
    private final long m_usedEdenSpace;
    private final long m_maxEdenSpace;
    private final long m_usedSurvivorSpace;
    private final long m_maxSurvivorSpace;
    private final long m_usedNonHeapMemory;
    private final long m_maxNonHeapMemory;
    private MBeanServer m_mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String DIRECT_BUFFER_MBEAN = "java.nio:type=BufferPool,name=direct";
    private static final String MAPPED_BUFFER_MBEAN = "java.nio:type=BufferPool,name=mapped";

    public MemoryInformations() {
        this.m_usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.m_maxMemory = Runtime.getRuntime().maxMemory();
        MemoryPoolMXBean permGenMemoryPool = this.getPermGenMemoryPool();
        if (permGenMemoryPool != null) {
            MemoryUsage usage = permGenMemoryPool.getUsage();
            this.m_usedPermGen = usage.getUsed();
            this.m_maxPermGen = usage.getMax();
        } else {
            this.m_usedPermGen = 0L;
            this.m_maxPermGen = 0L;
        }
        MemoryPoolMXBean oldGenMemoryPool = this.getOldGenMemoryPool();
        if (oldGenMemoryPool != null) {
            MemoryUsage usage = oldGenMemoryPool.getUsage();
            this.m_usedOldGen = usage.getUsed();
            this.m_maxOldGen = usage.getMax();
        } else {
            this.m_usedOldGen = 0L;
            this.m_maxOldGen = 0L;
        }
        MemoryPoolMXBean edenSpaceMemoryPool = this.getEdenSpacePool();
        if (edenSpaceMemoryPool != null) {
            MemoryUsage usage = edenSpaceMemoryPool.getUsage();
            this.m_usedEdenSpace = usage.getUsed();
            this.m_maxEdenSpace = usage.getMax();
        } else {
            this.m_usedEdenSpace = 0L;
            this.m_maxEdenSpace = 0L;
        }
        MemoryPoolMXBean survivorSpacePool = this.getSurvivorSpaceMemoryPool();
        if (survivorSpacePool != null) {
            MemoryUsage usage = survivorSpacePool.getUsage();
            this.m_usedSurvivorSpace = usage.getUsed();
            this.m_maxSurvivorSpace = usage.getMax();
        } else {
            this.m_usedSurvivorSpace = 0L;
            this.m_maxSurvivorSpace = 0L;
        }
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        this.m_usedNonHeapMemory = nonHeapMemoryUsage.getUsed();
        this.m_maxNonHeapMemory = nonHeapMemoryUsage.getMax();
    }

    private MemoryPoolMXBean getEdenSpacePool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Eden Space")) continue;
            return memoryPool;
        }
        return null;
    }

    public long getMaxEdenSpace() {
        return this.m_maxEdenSpace;
    }

    public long getMaxMemory() {
        return this.m_maxMemory;
    }

    public long getMaxNonHeapMemory() {
        return this.m_maxNonHeapMemory;
    }

    public long getMaxOldGen() {
        return this.m_maxOldGen;
    }

    public long getMaxPermGen() {
        return this.m_maxPermGen;
    }

    public long getMaxSurvivorSpace() {
        return this.m_maxSurvivorSpace;
    }

    private MemoryPoolMXBean getOldGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Old Gen")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getPermGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Perm Gen")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getSurvivorSpaceMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Survivor Space")) continue;
            return memoryPool;
        }
        return null;
    }

    public long getUsedDirectBufferSize() {
        long directBufferSize = 0L;
        try {
            ObjectName directPool = new ObjectName(DIRECT_BUFFER_MBEAN);
            directBufferSize = (Long)this.m_mbeanServer.getAttribute(directPool, "MemoryUsed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return directBufferSize;
    }

    public long getUsedEdenSpace() {
        return this.m_usedEdenSpace;
    }

    public double getUsedEdenSpacePercentage() {
        if (this.m_usedEdenSpace > 0L && this.m_maxEdenSpace > 0L) {
            return 100.0 * (double)this.m_usedEdenSpace / (double)this.m_maxEdenSpace;
        }
        return 0.0;
    }

    public long getUsedMappedSize() {
        long mappedBufferSize = 0L;
        try {
            ObjectName directPool = new ObjectName(MAPPED_BUFFER_MBEAN);
            mappedBufferSize = (Long)this.m_mbeanServer.getAttribute(directPool, "MemoryUsed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mappedBufferSize;
    }

    public long getUsedMemory() {
        return this.m_usedMemory;
    }

    public double getUsedMemoryPercentage() {
        return 100.0 * (double)this.m_usedMemory / (double)this.m_maxMemory;
    }

    public long getUsedNonHeapMemory() {
        return this.m_usedNonHeapMemory;
    }

    public double getUsedNonHeapPercentage() {
        if (this.m_usedNonHeapMemory > 0L && this.m_maxNonHeapMemory > 0L) {
            return 100.0 * (double)this.m_usedNonHeapMemory / (double)this.m_maxNonHeapMemory;
        }
        return 0.0;
    }

    public long getUsedOldGen() {
        return this.m_usedOldGen;
    }

    public double getUsedOldGenPercentage() {
        if (this.m_usedOldGen > 0L && this.m_maxOldGen > 0L) {
            return 100.0 * (double)this.m_usedOldGen / (double)this.m_maxOldGen;
        }
        return 0.0;
    }

    public long getUsedPermGen() {
        return this.m_usedPermGen;
    }

    public double getUsedPermGenPercentage() {
        if (this.m_usedPermGen > 0L && this.m_maxPermGen > 0L) {
            return 100.0 * (double)this.m_usedPermGen / (double)this.m_maxPermGen;
        }
        return 0.0;
    }

    public long getUsedSurvivorSpace() {
        return this.m_usedSurvivorSpace;
    }

    public double getUsedSurvivorSpacePercentage() {
        if (this.m_usedSurvivorSpace > 0L && this.m_maxSurvivorSpace > 0L) {
            return 100.0 * (double)this.m_usedSurvivorSpace / (double)this.m_maxSurvivorSpace;
        }
        return 0.0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[usedMemory=" + this.getUsedMemory() + ", maxMemroy=" + this.getMaxMemory() + ']';
    }
}

