/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.jvm;

import com.dianping.cat.Cat;
import com.dianping.cat.status.AbstractCollector;
import com.dianping.cat.status.StatusExtensionRegister;
import com.dianping.cat.status.jvm.MemoryInformations;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JvmInfoCollector {
    private static JvmInfoCollector s_collector = new JvmInfoCollector();
    private boolean m_hasOldGc = false;
    private long m_lastGcCount = 0L;
    private long m_lastGcTime = 0L;
    private long m_lastFullgcTime = 0L;
    private long m_lastFullgcCount = 0L;
    private long m_lastYounggcTime = 0L;
    private long m_lastYounggcCount = 0L;
    private Set<String> younggcAlgorithm = new LinkedHashSet<String>(){
        private static final long serialVersionUID = -2953196532584721351L;
        {
            this.add("Copy");
            this.add("ParNew");
            this.add("PS Scavenge");
            this.add("G1 Young Generation");
        }
    };
    private Set<String> oldgcAlgorithm = new LinkedHashSet<String>(){
        private static final long serialVersionUID = -8267829533109860610L;
        {
            this.add("MarkSweepCompact");
            this.add("PS MarkSweep");
            this.add("ConcurrentMarkSweep");
            this.add("G1 Old Generation");
        }
    };

    public static Map<String, String> convert(Map<String, Number> map) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Number> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public static JvmInfoCollector getInstance() {
        return s_collector;
    }

    private JvmInfoCollector() {
    }

    private Map<String, Number> doGcCollect() {
        long gcCount = 0L;
        long gcTime = 0L;
        long oldGCount = 0L;
        long oldGcTime = 0L;
        long youngGcCount = 0L;
        long youngGcTime = 0L;
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        for (GarbageCollectorMXBean garbageCollector : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += garbageCollector.getCollectionTime();
            gcCount += garbageCollector.getCollectionCount();
            String gcAlgorithm = garbageCollector.getName();
            if (this.younggcAlgorithm.contains(gcAlgorithm)) {
                youngGcTime += garbageCollector.getCollectionTime();
                youngGcCount += garbageCollector.getCollectionCount();
                continue;
            }
            if (this.oldgcAlgorithm.contains(gcAlgorithm)) {
                oldGcTime += garbageCollector.getCollectionTime();
                oldGCount += garbageCollector.getCollectionCount();
                continue;
            }
            Cat.logEvent("UnknowGcAlgorithm", gcAlgorithm);
        }
        map.put("jvm.gc.count", gcCount - this.m_lastGcCount);
        map.put("jvm.gc.time", gcTime - this.m_lastGcTime);
        long value = oldGCount - this.m_lastFullgcCount;
        if (value > 0L) {
            this.m_hasOldGc = true;
        }
        map.put("jvm.fullgc.count", value);
        map.put("jvm.fullgc.time", oldGcTime - this.m_lastFullgcTime);
        map.put("jvm.younggc.count", youngGcCount - this.m_lastYounggcCount);
        map.put("jvm.younggc.time", youngGcTime - this.m_lastYounggcTime);
        if (youngGcCount > this.m_lastYounggcCount) {
            map.put("jvm.younggc.meantime", (youngGcTime - this.m_lastYounggcTime) / (youngGcCount - this.m_lastYounggcCount));
        } else {
            map.put("jvm.younggc.meantime", 0);
        }
        this.m_lastGcCount = gcCount;
        this.m_lastGcTime = gcTime;
        this.m_lastYounggcCount = youngGcCount;
        this.m_lastYounggcTime = youngGcTime;
        this.m_lastFullgcCount = oldGCount;
        this.m_lastFullgcTime = oldGcTime;
        return map;
    }

    private Map<String, Number> doMemoryCollect() {
        MemoryInformations memInfo = new MemoryInformations();
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put("jvm.memory.used", memInfo.getUsedMemory());
        map.put("jvm.memory.used.percent", memInfo.getUsedMemoryPercentage());
        map.put("jvm.memory.nonheap.used", memInfo.getUsedNonHeapMemory());
        map.put("jvm.memory.nonheap.used.percent", memInfo.getUsedNonHeapPercentage());
        map.put("jvm.memory.oldgen.used", memInfo.getUsedOldGen());
        map.put("jvm.memory.oldgen.used.percent", memInfo.getUsedOldGenPercentage());
        if (this.m_hasOldGc) {
            map.put("jvm.memory.oldgen.used.percent.after.fullgc", memInfo.getUsedOldGenPercentage());
            this.m_hasOldGc = false;
        } else {
            map.put("jvm.memory.oldgen.used.percent.after.fullgc", 0);
        }
        map.put("jvm.memory.eden.used", memInfo.getUsedEdenSpace());
        map.put("jvm.memory.eden.used.percent", memInfo.getUsedEdenSpacePercentage());
        map.put("jvm.memory.survivor.used", memInfo.getUsedSurvivorSpace());
        map.put("jvm.memory.survivor.used.percent", memInfo.getUsedSurvivorSpacePercentage());
        map.put("jvm.memory.perm.used", memInfo.getUsedPermGen());
        map.put("jvm.memory.perm.used.percent", memInfo.getUsedPermGenPercentage());
        map.put("jvm.nio.directbuffer.used", memInfo.getUsedDirectBufferSize());
        map.put("jvm.nio.mapped.used", memInfo.getUsedMappedSize());
        return map;
    }

    public void registerJVMCollector() {
        StatusExtensionRegister instance = StatusExtensionRegister.getInstance();
        instance.register(new AbstractCollector(){

            @Override
            public String getId() {
                return "jvm.gc";
            }

            @Override
            public Map<String, String> getProperties() {
                Map map = s_collector.doGcCollect();
                return this.convert(map);
            }
        });
        instance.register(new AbstractCollector(){

            @Override
            public String getId() {
                return "jvm.memory";
            }

            @Override
            public Map<String, String> getProperties() {
                Map map = s_collector.doMemoryCollect();
                return this.convert(map);
            }
        });
    }
}

