/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.datasource.druid;

import com.dianping.cat.status.datasource.DataSourceCollector;
import com.dianping.cat.status.datasource.DatabaseParserHelper;
import com.dianping.cat.status.datasource.druid.DruidMonitorInfo;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.unidal.helper.Properties;

public class DruidInfoCollector
extends DataSourceCollector {
    private static final String PREFIX_KEY = "druid";

    private Map<String, Number> doCollect() {
        Map<String, DruidMonitorInfo> druidMonitorInfoMap = this.getDruidMonitorInfoMap();
        HashMap<String, Number> map = new HashMap<String, Number>();
        String detail = (String)Properties.forString().fromEnv().fromSystem().getProperty("CAT_DATASOURCE_DETAIL", (Object)"false");
        for (Map.Entry<String, DruidMonitorInfo> entry : druidMonitorInfoMap.entrySet()) {
            String dataSourceName = entry.getKey();
            DruidMonitorInfo value = entry.getValue();
            map.put("druid." + dataSourceName + ".busy_connection", value.getActiveCount());
            map.put("druid." + dataSourceName + ".total_connection", value.getPoolingCount());
            map.put("druid." + dataSourceName + ".idle_connection", value.getPoolingCount() - value.getActiveCount());
            if (!"true".equals(detail)) continue;
            map.put("druid." + dataSourceName + ".active_count", value.getActiveCount());
            map.put("druid." + dataSourceName + ".pooling_count", value.getPoolingCount());
            map.put("druid." + dataSourceName + ".connect_count", value.getConnectCount());
            map.put("druid." + dataSourceName + ".connect_error_count", value.getConnectErrorCount());
            map.put("druid." + dataSourceName + ".close_count", value.getCloseCount());
            map.put("druid." + dataSourceName + ".close_prepared_statement_count", value.getClosedPreparedStatementCount());
            map.put("druid." + dataSourceName + ".commit_count", value.getCommitCount());
            map.put("druid." + dataSourceName + ".create_count", value.getCreateCount());
            map.put("druid." + dataSourceName + ".create_error_count", value.getCreateErrorCount());
            map.put("druid." + dataSourceName + ".create_timespan_millis", value.getCreateTimespanMillis());
            map.put("druid." + dataSourceName + ".avg_create_timespan_millis", value.getAvgCreateTimespanMillis());
            map.put("druid." + dataSourceName + ".destroy_count", value.getDestroyCount());
            map.put("druid." + dataSourceName + ".discard_count", value.getDiscardCount());
            map.put("druid." + dataSourceName + ".error_count", value.getErrorCount());
            map.put("druid." + dataSourceName + ".lock_queue_length", value.getLockQueueLength());
            map.put("druid." + dataSourceName + ".max_active", value.getMaxActive());
            map.put("druid." + dataSourceName + ".max_idle", value.getMaxIdle());
            map.put("druid." + dataSourceName + ".max_open_prepared_statements", value.getMaxOpenPreparedStatements());
            map.put("druid." + dataSourceName + ".max_pool_prepared_statement_pre_connection_size", entry.getValue().getMaxPoolPreparedStatementPerConnectionSize());
            map.put("druid." + dataSourceName + ".not_empty_wait_count", value.getNotEmptyWaitCount());
            map.put("druid." + dataSourceName + ".not_empty_wait_millis", value.getNotEmptyWaitMillis());
            map.put("druid." + dataSourceName + ".avg_not_empty_wait_millis", value.getAvgNotEmptyWaitMillis());
            map.put("druid." + dataSourceName + ".not_empty_wait_thread_count", value.getNotEmptyWaitThreadCount());
            map.put("druid." + dataSourceName + ".wait_thread_count", value.getWaitThreadCount());
            map.put("druid." + dataSourceName + ".recycle_count", value.getRecycleCount());
            map.put("druid." + dataSourceName + ".rollback_count", value.getRollbackCount());
            map.put("druid." + dataSourceName + ".start_transaction_count", value.getStartTransactionCount());
            map.put("druid." + dataSourceName + ".max_wait", value.getMaxWait());
            map.put("druid." + dataSourceName + ".max_wait_thread_count", value.getMaxWaitThreadCount());
            map.put("druid." + dataSourceName + ".min_idle", value.getMinIdle());
            map.put("druid." + dataSourceName + ".query_timeout", value.getQueryTimeout());
            map.put("druid." + dataSourceName + ".dup_close_count", value.getDupCloseCount());
            map.put("druid." + dataSourceName + ".initial_size", value.getInitialSize());
            map.put("druid." + dataSourceName + ".remove_abandoned_count", value.getRemoveAbandonedCount());
        }
        return map;
    }

    private DruidMonitorInfo getDruidMonitorInfo(ObjectName objectName) {
        DruidMonitorInfo druidMonitorInfo = new DruidMonitorInfo();
        String jdbcUrl = this.getStringAttribute(objectName, "Url");
        druidMonitorInfo.setJdbcUrl(jdbcUrl);
        druidMonitorInfo.setActiveCount(this.getIntegerAttribute(objectName, "ActiveCount", false));
        druidMonitorInfo.setConnectCount(this.getLongAttribute(objectName, "ConnectCount", true));
        druidMonitorInfo.setConnectErrorCount(this.getLongAttribute(objectName, "ConnectErrorCount", true));
        druidMonitorInfo.setCloseCount(this.getLongAttribute(objectName, "CloseCount", true));
        druidMonitorInfo.setClosedPreparedStatementCount(this.getLongAttribute(objectName, "ClosedPreparedStatementCount", true));
        druidMonitorInfo.setCommitCount(this.getLongAttribute(objectName, "CommitCount", true));
        druidMonitorInfo.setCreateCount(this.getLongAttribute(objectName, "CreateCount", true));
        druidMonitorInfo.setCreateErrorCount(this.getLongAttribute(objectName, "CreateErrorCount", true));
        druidMonitorInfo.setCreateTimespanMillis(this.getLongAttribute(objectName, "CreateTimespanMillis", true));
        druidMonitorInfo.setDestroyCount(this.getLongAttribute(objectName, "DestroyCount", true));
        druidMonitorInfo.setDiscardCount(this.getLongAttribute(objectName, "DiscardCount", true));
        druidMonitorInfo.setErrorCount(this.getLongAttribute(objectName, "ErrorCount", true));
        druidMonitorInfo.setLockQueueLength(this.getIntegerAttribute(objectName, "LockQueueLength", false));
        druidMonitorInfo.setMaxActive(this.getIntegerAttribute(objectName, "MaxActive", false));
        druidMonitorInfo.setMaxIdle(this.getIntegerAttribute(objectName, "MaxIdle", false));
        druidMonitorInfo.setMaxOpenPreparedStatements(this.getIntegerAttribute(objectName, "MaxOpenPreparedStatements", false));
        druidMonitorInfo.setMaxPoolPreparedStatementPerConnectionSize(this.getIntegerAttribute(objectName, "MaxPoolPreparedStatementPerConnectionSize", false));
        druidMonitorInfo.setNotEmptyWaitCount(this.getLongAttribute(objectName, "NotEmptyWaitCount", true));
        druidMonitorInfo.setNotEmptyWaitMillis(this.getLongAttribute(objectName, "NotEmptyWaitMillis", true));
        druidMonitorInfo.setNotEmptyWaitThreadCount(this.getIntegerAttribute(objectName, "NotEmptyWaitThreadCount", false));
        druidMonitorInfo.setWaitThreadCount(this.getIntegerAttribute(objectName, "WaitThreadCount", false));
        druidMonitorInfo.setPoolingCount(this.getIntegerAttribute(objectName, "PoolingCount", false));
        druidMonitorInfo.setRecycleCount(this.getLongAttribute(objectName, "RecycleCount", true));
        druidMonitorInfo.setRollbackCount(this.getLongAttribute(objectName, "RollbackCount", true));
        druidMonitorInfo.setStartTransactionCount(this.getLongAttribute(objectName, "StartTransactionCount", true));
        druidMonitorInfo.setMaxWait(this.getLongAttribute(objectName, "MaxWait", false));
        druidMonitorInfo.setMaxWaitThreadCount(this.getIntegerAttribute(objectName, "MaxWaitThreadCount", false));
        druidMonitorInfo.setMinIdle(this.getIntegerAttribute(objectName, "MinIdle", false));
        druidMonitorInfo.setQueryTimeout(this.getIntegerAttribute(objectName, "QueryTimeout", false));
        druidMonitorInfo.setDupCloseCount(this.getLongAttribute(objectName, "DupCloseCount", true));
        druidMonitorInfo.setInitialSize(this.getIntegerAttribute(objectName, "InitialSize", false).intValue());
        druidMonitorInfo.setRemoveAbandonedCount(this.getLongAttribute(objectName, "RemoveAbandonedCount", true));
        return druidMonitorInfo;
    }

    private Map<String, DruidMonitorInfo> getDruidMonitorInfoMap() {
        HashMap<String, DruidMonitorInfo> dataSourceInfoMap = new HashMap<String, DruidMonitorInfo>();
        try {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("type", "DruidDataSource");
            table.put("id", "*");
            ObjectName pooledDataSourceObjectName = new ObjectName("com.alibaba.druid", table);
            Set<ObjectName> objectNameSet = this.m_mbeanServer.queryNames(pooledDataSourceObjectName, null);
            if (objectNameSet == null || objectNameSet.isEmpty()) {
                return dataSourceInfoMap;
            }
            LinkedHashMap<String, Integer> datasources = new LinkedHashMap<String, Integer>();
            for (ObjectName objectName : objectNameSet) {
                DruidMonitorInfo info = this.getDruidMonitorInfo(objectName);
                String url = info.getJdbcUrl();
                DatabaseParserHelper.Database datasource = this.m_databaseParser.parseDatabase(url);
                String key = this.getConnction(datasources, datasource.toString());
                dataSourceInfoMap.put(key, info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataSourceInfoMap;
    }

    @Override
    public String getId() {
        return "datasource.druid";
    }

    @Override
    public Map<String, String> getProperties() {
        return this.convert(this.doCollect());
    }
}

