/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.datasource.c3p0;

import com.dianping.cat.status.datasource.DataSourceCollector;
import com.dianping.cat.status.datasource.DatabaseParserHelper;
import com.dianping.cat.status.datasource.c3p0.C3P0MonitorInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.unidal.helper.Properties;

public class C3P0InfoCollector
extends DataSourceCollector {
    private final String PREFIX_KEY = "c3p0";

    private Map<String, Number> doCollect() {
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        Map<String, C3P0MonitorInfo> c3P0MonitorInfoMap = this.getC3P0MonitorInfoMap();
        String detail = (String)Properties.forString().fromEnv().fromSystem().getProperty("CAT_DATASOURCE_DETAIL", (Object)"false");
        for (Map.Entry<String, C3P0MonitorInfo> entry : c3P0MonitorInfoMap.entrySet()) {
            String dataSourceName = entry.getKey();
            C3P0MonitorInfo value = entry.getValue();
            map.put("c3p0." + dataSourceName + ".busy_connection", value.getNumBusyConnections());
            map.put("c3p0." + dataSourceName + ".total_connection", value.getNumConnections());
            map.put("c3p0." + dataSourceName + ".idle_connection", value.getNumIdleConnections());
            if (!"true".equals(detail)) continue;
            map.put("c3p0." + dataSourceName + ".failed_checkin", value.getNumFailedCheckins());
            map.put("c3p0." + dataSourceName + ".failed_checkout", value.getNumFailedCheckouts());
            map.put("c3p0." + dataSourceName + ".failed_test", value.getNumFailedIdleTests());
        }
        return map;
    }

    private C3P0MonitorInfo getC3P0MonitorInfo(ObjectName objectName) {
        C3P0MonitorInfo c3P0MonitorInfo = new C3P0MonitorInfo();
        String jdbcUrl = this.getStringAttribute(objectName, "jdbcUrl");
        c3P0MonitorInfo.setJdbcUrl(jdbcUrl);
        c3P0MonitorInfo.setNumBusyConnections(this.getIntegerAttribute(objectName, "numBusyConnections", false));
        c3P0MonitorInfo.setNumConnections(this.getIntegerAttribute(objectName, "numConnections", false));
        c3P0MonitorInfo.setNumIdleConnections(this.getIntegerAttribute(objectName, "numIdleConnections", false));
        c3P0MonitorInfo.setNumFailedCheckins(this.getLongAttribute(objectName, "numFailedCheckinsDefaultUser", false));
        c3P0MonitorInfo.setNumFailedCheckouts(this.getLongAttribute(objectName, "numFailedCheckoutsDefaultUser", false));
        c3P0MonitorInfo.setNumFailedIdleTests(this.getLongAttribute(objectName, "numFailedIdleTestsDefaultUser", false));
        return c3P0MonitorInfo;
    }

    private Map<String, C3P0MonitorInfo> getC3P0MonitorInfoMap() {
        LinkedHashMap<String, C3P0MonitorInfo> dataSourceInfoMap = new LinkedHashMap<String, C3P0MonitorInfo>();
        try {
            ObjectName pooledDataSourceObjectName = new ObjectName("com.mchange.v2.c3p0", "type", "PooledDataSource*");
            Set<ObjectName> objectNameSet = this.m_mbeanServer.queryNames(pooledDataSourceObjectName, null);
            if (objectNameSet == null || objectNameSet.isEmpty()) {
                return dataSourceInfoMap;
            }
            LinkedHashMap<String, Integer> datasources = new LinkedHashMap<String, Integer>();
            for (ObjectName objectName : objectNameSet) {
                C3P0MonitorInfo info = this.getC3P0MonitorInfo(objectName);
                String url = info.getJdbcUrl();
                DatabaseParserHelper.Database datasource = this.m_databaseParser.parseDatabase(url);
                String key = this.getConnction(datasources, datasource.toString());
                dataSourceInfoMap.put(key, info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataSourceInfoMap;
    }

    @Override
    public String getId() {
        return "datasource.c3p0";
    }

    @Override
    public Map<String, String> getProperties() {
        return this.convert(this.doCollect());
    }
}

