/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.datasource;

import com.dianping.cat.status.AbstractCollector;
import com.dianping.cat.status.datasource.DatabaseParserHelper;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class DataSourceCollector
extends AbstractCollector {
    protected Map<String, Object> m_lastValueMap = new HashMap<String, Object>();
    protected MBeanServer m_mbeanServer = ManagementFactory.getPlatformMBeanServer();
    protected DatabaseParserHelper m_databaseParser = new DatabaseParserHelper();
    protected static final char SPLIT = '.';
    protected static final Integer ERROR_INT = -1;
    protected static final Long ERROR_LONG = -1L;
    protected static final String ERROR_ATTRIBUTE = "unknown";

    private Integer diffLast(String key, Integer value) {
        Object lastValue = this.m_lastValueMap.get(key);
        if (lastValue != null) {
            this.m_lastValueMap.put(key, value);
            return value - (Integer)lastValue;
        }
        this.m_lastValueMap.put(key, value);
        return value;
    }

    private Long diffLast(String key, Long value) {
        Object lastValue = this.m_lastValueMap.get(key);
        if (lastValue != null) {
            this.m_lastValueMap.put(key, value);
            return value - (Long)lastValue;
        }
        this.m_lastValueMap.put(key, value);
        return value;
    }

    @Override
    public String getDescription() {
        return "datasource.c3p0";
    }

    @Override
    public String getId() {
        return "datasource.c3p0";
    }

    protected Integer getIntegerAttribute(ObjectName objectName, String attribute, Boolean isDiff) {
        try {
            Integer value = (Integer)this.m_mbeanServer.getAttribute(objectName, attribute);
            if (isDiff.booleanValue()) {
                return this.diffLast(objectName.getCanonicalName() + attribute, value);
            }
            return value;
        }
        catch (Exception e) {
            return ERROR_INT;
        }
    }

    protected Long getLongAttribute(ObjectName objectName, String attribute, Boolean isDiff) {
        try {
            Long value = (Long)this.m_mbeanServer.getAttribute(objectName, attribute);
            if (isDiff.booleanValue()) {
                return this.diffLast(objectName.getCanonicalName() + attribute, value);
            }
            return value;
        }
        catch (Exception e) {
            return ERROR_LONG;
        }
    }

    protected String getStringAttribute(ObjectName objectName, String attribute) {
        try {
            return (String)this.m_mbeanServer.getAttribute(objectName, attribute);
        }
        catch (Exception e) {
            return ERROR_ATTRIBUTE;
        }
    }

    protected String getConnction(Map<String, Integer> datasources, String key) {
        Integer index = datasources.get(key);
        if (index == null) {
            datasources.put(key, 0);
            return key;
        }
        Integer n = index;
        Integer n2 = index = Integer.valueOf(index + 1);
        datasources.put(key, index);
        return key + '[' + index + ']';
    }

    protected Boolean isRandomName(String name) {
        return name != null && name.length() > 30;
    }
}

