/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageStatistics;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import com.dianping.cat.status.datasource.c3p0.C3P0InfoCollector;
import com.dianping.cat.status.datasource.druid.DruidInfoCollector;
import com.dianping.cat.status.jvm.ClassLoadingInfoCollector;
import com.dianping.cat.status.jvm.JvmInfoCollector;
import com.dianping.cat.status.jvm.ThreadInfoCollector;
import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.StatusInfo;
import com.dianping.cat.status.send.HttpAgentSender;
import com.dianping.cat.status.send.HttpSendConfig;
import com.dianping.cat.status.system.ProcessorInfoCollector;
import com.dianping.cat.status.system.StaticInfoCollector;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class StatusUpdateTask
implements Threads.Task,
Initializable {
    @Inject
    private MessageStatistics m_statistics;
    @Inject
    private ClientConfigManager m_manager;
    private HttpAgentSender m_sender;
    private boolean m_active = true;
    private boolean m_httpEnabled;
    private long m_interval = 60000L;
    private int m_updateSecond = 10;

    private void await() {
        Calendar cal;
        int second;
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while ((second = (cal = Calendar.getInstance()).get(13)) < 2 || second > 58) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExtenstion(StatusInfo status) {
        StatusExtensionRegister res = StatusExtensionRegister.getInstance();
        Map<String, StatusExtension> extensions = res.getStatusExtension();
        for (StatusExtension extension : extensions.values()) {
            Transaction t = Cat.newTransaction("System", "StatusExtension-" + extension.getId());
            try {
                Map<String, String> propertis = extension.getProperties();
                if (propertis.size() > 0) {
                    String id = extension.getId();
                    String des = extension.getDescription();
                    Extension item = status.findOrCreateExtension(id).setDescription(des);
                    long mills = System.currentTimeMillis();
                    for (Map.Entry<String, String> entry : propertis.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        try {
                            double doubleValue = Double.parseDouble(value);
                            item.findOrCreateExtensionDetail(key).setValue(doubleValue);
                            if (!this.m_httpEnabled || this.jmonitorExsit() && id.contains("jvm")) continue;
                            this.m_sender.asyncSend(key, value, mills);
                        }
                        catch (Exception e) {
                            status.getCustomInfos().put(key, new CustomInfo().setKey(key).setValue(value));
                        }
                    }
                }
                t.setSuccessStatus();
            }
            catch (Exception e) {
                t.setStatus(e);
            }
            finally {
                t.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHeartbeat(String localHostAddress) {
        Transaction t = Cat.newTransaction("System", "Status");
        Heartbeat h = Cat.getProducer().newHeartbeat("Heartbeat", localHostAddress);
        StatusInfo status = new StatusInfo();
        Cat.getManager().getThreadLocalMessageTree().setDiscard(false);
        try {
            this.buildExtenstion(status);
            h.addData(status.toString());
            h.setStatus("0");
        }
        catch (Throwable e) {
            h.setStatus(e);
            Cat.logError(e);
        }
        finally {
            h.complete();
        }
        String eventName = this.calMinuteString();
        Cat.logEvent("Heartbeat", eventName, "0", this.buildJstack());
        t.setStatus("0");
        t.complete();
    }

    private String buildJstack() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        bean.setThreadContentionMonitoringEnabled(true);
        ThreadInfo[] threads = bean.dumpAllThreads(false, false);
        return this.threadDump(threads);
    }

    private String calMinuteString() {
        Calendar cal = Calendar.getInstance();
        int minute = cal.get(12);
        String eventName = null;
        eventName = minute < 10 ? "jstack-0" + minute : "jstack-" + minute;
        return eventName;
    }

    public String getName() {
        return "StatusUpdateTask";
    }

    public void initialize() throws InitializationException {
        try {
            JvmInfoCollector.getInstance().registerJVMCollector();
            StatusExtensionRegister instance = StatusExtensionRegister.getInstance();
            instance.register(new StaticInfoCollector());
            instance.register(new ClassLoadingInfoCollector());
            instance.register(new ThreadInfoCollector());
            if (!this.isDocker()) {
                instance.register(new ProcessorInfoCollector());
            }
            instance.register(new C3P0InfoCollector());
            instance.register(new DruidInfoCollector());
            HttpSendConfig config = HttpSendConfig.loadDefaultConfig();
            boolean bl = this.m_httpEnabled = !config.isDisabled();
            if (this.m_httpEnabled) {
                this.m_sender = HttpAgentSender.getInstance(config);
                this.m_sender.initWorkThread();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isDocker() {
        File file = new File("/data/webapps/hulk");
        String hostname = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        return hostname.startsWith("set-") || file.exists();
    }

    private boolean jmonitorExsit() {
        try {
            Class.forName("com.meituan.jmonitor.config.JMonitorConfig");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void refreshClientConfig() {
        try {
            long current = System.currentTimeMillis() / 1000L / 60L;
            int min = (int)(current % 60L);
            if (min % 3 == 0) {
                this.m_manager.refreshConfig();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.await();
        String localHostAddress = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        Cat.logEvent("Reboot", localHostAddress, "0", null);
        while (this.m_active) {
            long start = System.currentTimeMillis();
            this.buildHeartbeat(localHostAddress);
            this.refreshClientConfig();
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed >= this.m_interval) continue;
            this.m_active = this.sleepToNextMinuteSecond(this.m_updateSecond);
        }
    }

    public void shutdown() {
        this.m_active = false;
    }

    public boolean sleepToNextMinuteSecond(int overSeconds) {
        try {
            long current = System.currentTimeMillis();
            Thread.sleep(this.m_interval - current % this.m_interval + (long)overSeconds * 1000L);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private String threadDump(ThreadInfo[] threads) {
        StringBuilder sb = new StringBuilder(32768);
        int index = 1;
        TreeMap<String, ThreadInfo> sortedThreads = new TreeMap<String, ThreadInfo>();
        for (ThreadInfo thread : threads) {
            sortedThreads.put(thread.getThreadName(), thread);
        }
        for (ThreadInfo thread : sortedThreads.values()) {
            sb.append(index++).append(": ").append(thread);
        }
        return sb.toString();
    }
}

