/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.servlet;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMessageManager;
import com.dianping.cat.message.internal.DefaultTransaction;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unidal.helper.Joiners;

public class CatFilter
implements Filter {
    private String m_servers;
    private Set<String> m_excludeUrls;
    private static final char SPLIT = '/';

    private void customizeStatus(Transaction t, HttpServletRequest req) {
        Object catStatus = req.getAttribute("cat-state");
        if (catStatus != null) {
            t.setStatus(catStatus.toString());
        } else {
            t.setStatus("0");
        }
    }

    private void customizeUri(Transaction t, HttpServletRequest req) {
        if (t instanceof DefaultTransaction) {
            Object catPageUri;
            Object catPageType = req.getAttribute("cat-page-type");
            if (catPageType instanceof String) {
                ((DefaultTransaction)t).setType(catPageType.toString());
            }
            if ((catPageUri = req.getAttribute("cat-page-uri")) instanceof String) {
                ((DefaultTransaction)t).setName(catPageUri.toString());
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String path = req.getRequestURI();
        if (this.m_excludeUrls != null && this.m_excludeUrls.contains(path)) {
            chain.doFilter(request, response);
            return;
        }
        this.logTransaction(chain, req, res);
    }

    private String getCatServer() {
        try {
            if (this.m_servers == null) {
                DefaultMessageManager manager = (DefaultMessageManager)Cat.getManager();
                List<Server> servers = manager.getConfigManager().getServers();
                this.m_servers = Joiners.by((char)',').join(servers, (Joiners.IBuilder)new Joiners.IBuilder<Server>(){

                    public String asString(Server server) {
                        String ip = server.getIp();
                        Integer httpPort = server.getHttpPort();
                        return ip + ":" + httpPort;
                    }
                });
            }
            return this.m_servers;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getRequestURI(HttpServletRequest req) {
        String url = req.getRequestURI();
        int length = url.length();
        StringBuilder sb = new StringBuilder(length);
        int index = 0;
        block0: while (index < length) {
            char c = url.charAt(index);
            if (c == '/' && index < length - 1) {
                sb.append(c);
                StringBuilder nextSection = new StringBuilder();
                boolean isNumber = false;
                boolean first = true;
                for (int j = index + 1; j < length; ++j) {
                    char next = url.charAt(j);
                    if ((first || isNumber) && next != '/') {
                        isNumber = this.isNumber(next);
                        first = false;
                    }
                    if (next == '/') {
                        if (isNumber) {
                            sb.append("{num}");
                        } else {
                            sb.append(nextSection.toString());
                        }
                        index = j;
                        continue block0;
                    }
                    if (j == length - 1) {
                        if (isNumber) {
                            sb.append("{num}");
                        } else {
                            nextSection.append(next);
                            sb.append(nextSection.toString());
                        }
                        index = j + 1;
                        continue block0;
                    }
                    nextSection.append(next);
                }
                continue;
            }
            sb.append(c);
            ++index;
        }
        return sb.toString();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String exclude = filterConfig.getInitParameter("exclude");
        if (exclude != null) {
            String[] excludeUrls;
            this.m_excludeUrls = new HashSet<String>();
            for (String s : excludeUrls = exclude.split(";")) {
                this.m_excludeUrls.add(s);
            }
        }
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == '-' || c == ',';
    }

    private void logCatMessageId(HttpServletResponse res) throws IOException, ServletException {
        boolean isTraceMode = Cat.getManager().isTraceMode();
        if (isTraceMode) {
            String id = Cat.getCurrentMessageId();
            res.setHeader("X-CAT-ROOT-ID", id);
            res.setHeader("X-CAT-SERVER", this.getCatServer());
        }
    }

    private void logPayload(HttpServletRequest req, boolean top, String type) {
        try {
            if (top) {
                this.logRequestClientInfo(req, type);
                this.logRequestPayload(req, type);
            } else {
                this.logRequestPayload(req, type);
            }
        }
        catch (Exception e) {
            Cat.logError(e);
        }
    }

    private void logRequestClientInfo(HttpServletRequest req, String type) {
        StringBuilder sb = new StringBuilder(1024);
        String ip = "";
        String ipForwarded = req.getHeader("x-forwarded-for");
        ip = ipForwarded == null ? req.getRemoteAddr() : ipForwarded;
        sb.append("IPS=").append(ip);
        sb.append("&VirtualIP=").append(req.getRemoteAddr());
        sb.append("&Server=").append(req.getServerName());
        sb.append("&Referer=").append(req.getHeader("referer"));
        sb.append("&Agent=").append(req.getHeader("user-agent"));
        Cat.logEvent(type, type + ".Server", "0", sb.toString());
    }

    private void logRequestPayload(HttpServletRequest req, String type) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(req.getScheme().toUpperCase()).append('/');
        sb.append(req.getMethod()).append(' ').append(req.getRequestURI());
        String qs = req.getQueryString();
        if (qs != null) {
            sb.append('?').append(qs);
        }
        Cat.logEvent(type, type + ".Method", "0", sb.toString());
    }

    private void logTraceMode(HttpServletRequest req) {
        String traceMode = "X-CAT-TRACE-MODE";
        String headMode = req.getHeader(traceMode);
        if ("true".equals(headMode)) {
            Cat.getManager().setTraceMode(true);
        }
    }

    private void logTransaction(FilterChain chain, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean top = !Cat.getManager().hasContext();
        String type = null;
        if (top) {
            type = "URL";
            this.logTraceMode(req);
        } else {
            type = "URL.Forward";
        }
        Transaction t = Cat.newTransaction(type, this.getRequestURI(req));
        try {
            this.logPayload(req, top, type);
            this.logCatMessageId(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            this.customizeStatus(t, req);
        }
        catch (ServletException e) {
            t.setStatus(e);
            Cat.logError(e);
            throw e;
        }
        catch (IOException e) {
            t.setStatus(e);
            Cat.logError(e);
            throw e;
        }
        catch (Throwable e) {
            t.setStatus(e);
            Cat.logError(e);
            throw new RuntimeException(e);
        }
        finally {
            this.customizeUri(t, req);
            t.complete();
        }
    }
}

