/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.PlainTextMessageCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultMessageTree
implements MessageTree {
    private ByteBuf m_buf;
    private String m_domain;
    private String m_hostName;
    private String m_ipAddress;
    private Message m_message;
    private String m_messageId;
    private String m_parentMessageId;
    private String m_rootMessageId;
    private String m_sessionToken;
    private String m_threadGroupName;
    private String m_threadId;
    private String m_threadName;
    private MessageId m_formatMessageId;
    private boolean m_discard = true;
    private boolean m_processLoss = false;
    private boolean m_hitSample = false;
    private List<Transaction> m_transactions;
    private List<Event> m_events;
    private List<Heartbeat> m_heartbeats;
    private List<Metric> m_metrics;
    private List<ForkableTransaction> m_forkableTransactions;

    @Override
    public synchronized void addForkableTransaction(ForkableTransaction forkableTransaction) {
        if (this.m_forkableTransactions == null) {
            this.m_forkableTransactions = new ArrayList<ForkableTransaction>();
        }
        this.m_forkableTransactions.add(forkableTransaction);
    }

    @Override
    public List<ForkableTransaction> getForkableTransactions() {
        if (this.m_forkableTransactions != null) {
            return this.m_forkableTransactions;
        }
        return Collections.emptyList();
    }

    public void addHeartbeat(Heartbeat heartbeat) {
        if (this.m_heartbeats == null) {
            this.m_heartbeats = new ArrayList<Heartbeat>();
        }
        this.m_heartbeats.add(heartbeat);
    }

    @Override
    public boolean canDiscard() {
        return this.m_discard;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public MessageTree copy() {
        DefaultMessageTree tree = new DefaultMessageTree();
        tree.setDomain(this.m_domain);
        tree.setHostName(this.m_hostName);
        tree.setIpAddress(this.m_ipAddress);
        tree.setMessageId(this.m_messageId);
        tree.setParentMessageId(this.m_parentMessageId);
        tree.setRootMessageId(this.m_rootMessageId);
        tree.setSessionToken(this.m_sessionToken);
        tree.setThreadGroupName(this.m_threadGroupName);
        tree.setThreadId(this.m_threadId);
        tree.setThreadName(this.m_threadName);
        tree.setMessage(this.m_message);
        tree.setDiscard(this.m_discard);
        tree.setHitSample(this.m_hitSample);
        return tree;
    }

    public MessageTree copyForTest() {
        ByteBuf buf = null;
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = codec.encode(this);
            return codec.decode(buf);
        }
        catch (Exception ex) {
            Cat.logError(ex);
            return null;
        }
    }

    @Override
    public ByteBuf getBuffer() {
        return this.m_buf;
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public List<Event> getEvents() {
        if (this.m_events == null) {
            this.m_events = new ArrayList<Event>();
        }
        return this.m_events;
    }

    @Override
    public MessageId getFormatMessageId() {
        if (this.m_formatMessageId == null) {
            this.m_formatMessageId = MessageId.parse(this.m_messageId);
        }
        return this.m_formatMessageId;
    }

    @Override
    public List<Heartbeat> getHeartbeats() {
        if (this.m_heartbeats == null) {
            this.m_heartbeats = new ArrayList<Heartbeat>();
        }
        return this.m_heartbeats;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    @Override
    public Message getMessage() {
        return this.m_message;
    }

    @Override
    public String getMessageId() {
        return this.m_messageId;
    }

    @Override
    public List<Metric> getMetrics() {
        if (this.m_metrics == null) {
            this.m_metrics = new ArrayList<Metric>();
        }
        return this.m_metrics;
    }

    @Override
    public String getParentMessageId() {
        return this.m_parentMessageId;
    }

    @Override
    public String getRootMessageId() {
        return this.m_rootMessageId;
    }

    @Override
    public String getSessionToken() {
        return this.m_sessionToken;
    }

    @Override
    public String getThreadGroupName() {
        return this.m_threadGroupName;
    }

    @Override
    public String getThreadId() {
        return this.m_threadId;
    }

    @Override
    public String getThreadName() {
        return this.m_threadName;
    }

    @Override
    public List<Transaction> getTransactions() {
        if (this.m_transactions == null) {
            this.m_transactions = new ArrayList<Transaction>();
        }
        return this.m_transactions;
    }

    @Override
    public boolean isHitSample() {
        return this.m_hitSample;
    }

    @Override
    public boolean isProcessLoss() {
        return this.m_processLoss;
    }

    public void setBuffer(ByteBuf buf) {
        this.m_buf = buf;
    }

    @Override
    public void setDiscard(boolean discard) {
        this.m_discard = discard;
    }

    @Override
    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    @Override
    public void setFormatMessageId(MessageId formatMessageId) {
        this.m_formatMessageId = formatMessageId;
    }

    @Override
    public void setHitSample(boolean hitSample) {
        this.m_hitSample = hitSample;
    }

    @Override
    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @Override
    public void setMessage(Message message) {
        this.m_message = message;
    }

    @Override
    public void setMessageId(String messageId) {
        if (messageId != null && messageId.length() > 0) {
            this.m_messageId = messageId;
        }
    }

    @Override
    public void setParentMessageId(String parentMessageId) {
        if (parentMessageId != null && parentMessageId.length() > 0) {
            this.m_parentMessageId = parentMessageId;
        }
    }

    @Override
    public void setProcessLoss(boolean loss) {
        this.m_processLoss = loss;
    }

    @Override
    public void setRootMessageId(String rootMessageId) {
        if (rootMessageId != null && rootMessageId.length() > 0) {
            this.m_rootMessageId = rootMessageId;
        }
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.m_sessionToken = sessionToken;
    }

    @Override
    public void setThreadGroupName(String threadGroupName) {
        this.m_threadGroupName = threadGroupName;
    }

    @Override
    public void setThreadId(String threadId) {
        this.m_threadId = threadId;
    }

    @Override
    public void setThreadName(String threadName) {
        this.m_threadName = threadName;
    }

    public String toString() {
        return PlainTextMessageCodec.encodeTree(this);
    }

    public void clearMessageList() {
        if (this.m_transactions != null) {
            this.m_transactions.clear();
        }
        if (this.m_events != null) {
            this.m_events.clear();
        }
        if (this.m_heartbeats != null) {
            this.m_heartbeats.clear();
        }
        if (this.m_metrics != null) {
            this.m_metrics.clear();
        }
    }
}

