/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.internal;

import com.dianping.cat.message.spi.MessageStatistics;
import com.dianping.cat.message.spi.MessageTree;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.unidal.lookup.annotation.Named;

@Named(type=MessageStatistics.class)
public class DefaultMessageStatistics
implements MessageStatistics {
    private AtomicLong m_produced = new AtomicLong();
    private AtomicLong m_overflowed = new AtomicLong();
    private AtomicLong m_bytes = new AtomicLong();

    @Override
    public void onBytes(int bytes) {
        this.m_bytes.addAndGet(bytes);
        this.m_produced.incrementAndGet();
    }

    @Override
    public void onOverflowed(MessageTree tree) {
        this.m_overflowed.incrementAndGet();
    }

    @Override
    public Map<String, Long> getStatistics() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("cat.status.message.produced", this.m_produced.get());
        this.m_produced = new AtomicLong();
        map.put("cat.status.message.overflowed", this.m_overflowed.get());
        this.m_overflowed = new AtomicLong();
        map.put("cat.status.message.bytes", this.m_bytes.get());
        this.m_bytes = new AtomicLong();
        return map;
    }
}

