/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.codec;

import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultHeartbeat;
import com.dianping.cat.message.internal.DefaultMetric;
import com.dianping.cat.message.internal.DefaultTrace;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Stack;
import org.unidal.lookup.annotation.Named;

@Named(type=MessageCodec.class, value="NT1")
public class NativeMessageCodec
implements MessageCodec {
    public static final String ID = "NT1";

    @Override
    public MessageTree decode(ByteBuf buf) {
        buf.readInt();
        DefaultMessageTree tree = new DefaultMessageTree();
        Context ctx = new Context(tree);
        Codec.HEADER.decode(ctx, buf);
        Message msg = this.decodeMessage(ctx, buf);
        tree.setMessage(msg);
        tree.setBuffer(buf);
        return tree;
    }

    private Message decodeMessage(Context ctx, ByteBuf buf) {
        Message msg = null;
        block8: while (buf.readableBytes() > 0) {
            char ch = ctx.readId(buf);
            switch (ch) {
                case 't': {
                    Codec.TRANSACTION_START.decode(ctx, buf);
                    continue block8;
                }
                case 'T': {
                    msg = Codec.TRANSACTION_END.decode(ctx, buf);
                    continue block8;
                }
                case 'E': {
                    Message e = Codec.EVENT.decode(ctx, buf);
                    ctx.addChild(e);
                    continue block8;
                }
                case 'M': {
                    Message m = Codec.METRIC.decode(ctx, buf);
                    ctx.addChild(m);
                    continue block8;
                }
                case 'H': {
                    Message h = Codec.HEARTBEAT.decode(ctx, buf);
                    ctx.addChild(h);
                    continue block8;
                }
                case 'L': {
                    Message l = Codec.TRACE.decode(ctx, buf);
                    ctx.addChild(l);
                    continue block8;
                }
            }
            throw new RuntimeException(String.format("Unsupported message type(%s).", Character.valueOf(ch)));
        }
        if (msg == null) {
            msg = ctx.getMessageTree().getMessage();
        }
        return msg;
    }

    @Override
    public ByteBuf encode(MessageTree tree) {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(4096);
        Context ctx = new Context(tree);
        buf.writeInt(0);
        Codec.HEADER.encode(ctx, buf, null);
        Message msg = tree.getMessage();
        if (msg != null) {
            this.encodeMessage(ctx, buf, msg);
        }
        int readableBytes = buf.readableBytes();
        buf.setInt(0, readableBytes - 4);
        return buf;
    }

    private void encodeMessage(Context ctx, ByteBuf buf, Message msg) {
        if (msg instanceof Transaction) {
            Transaction transaction = (Transaction)msg;
            List<Message> children = transaction.getChildren();
            Codec.TRANSACTION_START.encode(ctx, buf, msg);
            for (Message child : children) {
                if (child == null) continue;
                this.encodeMessage(ctx, buf, child);
            }
            Codec.TRANSACTION_END.encode(ctx, buf, msg);
        } else if (msg instanceof Event) {
            Codec.EVENT.encode(ctx, buf, msg);
        } else if (msg instanceof Metric) {
            Codec.METRIC.encode(ctx, buf, msg);
        } else if (msg instanceof Heartbeat) {
            Codec.HEARTBEAT.encode(ctx, buf, msg);
        } else if (msg instanceof Trace) {
            Codec.TRACE.encode(ctx, buf, msg);
        } else {
            throw new RuntimeException(String.format("Unsupported message(%s).", msg));
        }
    }

    @Override
    public void reset() {
    }

    private static class Context {
        private static Charset UTF8 = Charset.forName("UTF-8");
        private MessageTree m_tree;
        private Stack<DefaultTransaction> m_parents = new Stack();
        private byte[] m_data = new byte[256];

        public Context(MessageTree tree) {
            this.m_tree = tree;
        }

        public void addChild(Message msg) {
            if (!this.m_parents.isEmpty()) {
                this.m_parents.peek().addChild(msg);
            } else {
                this.m_tree.setMessage(msg);
            }
        }

        public MessageTree getMessageTree() {
            return this.m_tree;
        }

        public String getVersion(ByteBuf buf) {
            byte[] data = new byte[3];
            buf.readBytes(data);
            return new String(data);
        }

        public DefaultTransaction popTransaction() {
            return this.m_parents.pop();
        }

        public void pushTransaction(DefaultTransaction t) {
            if (!this.m_parents.isEmpty()) {
                this.m_parents.peek().addChild(t);
            }
            this.m_parents.push(t);
        }

        public long readDuration(ByteBuf buf) {
            return this.readVarint(buf, 64);
        }

        public char readId(ByteBuf buf) {
            return (char)buf.readByte();
        }

        public String readString(ByteBuf buf) {
            int len = (int)this.readVarint(buf, 32);
            if (len == 0) {
                return "";
            }
            if (len > this.m_data.length) {
                this.m_data = new byte[len];
            }
            buf.readBytes(this.m_data, 0, len);
            return new String(this.m_data, 0, len);
        }

        public long readTimestamp(ByteBuf buf) {
            return this.readVarint(buf, 64);
        }

        protected long readVarint(ByteBuf buf, int length) {
            long result = 0L;
            for (int shift = 0; shift < length; shift += 7) {
                byte b = buf.readByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new RuntimeException("Malformed variable int " + length + "!");
        }

        public void writeDuration(ByteBuf buf, long duration) {
            this.writeVarint(buf, duration);
        }

        public void writeId(ByteBuf buf, char id) {
            buf.writeByte((int)id);
        }

        public void writeString(ByteBuf buf, String str) {
            if (str == null || str.length() == 0) {
                this.writeVarint(buf, 0L);
            } else {
                byte[] data = str.getBytes(UTF8);
                this.writeVarint(buf, data.length);
                buf.writeBytes(data);
            }
        }

        public void writeTimestamp(ByteBuf buf, long timestamp) {
            this.writeVarint(buf, timestamp);
        }

        private void writeVarint(ByteBuf buf, long value) {
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    buf.writeByte((int)((byte)value));
                    return;
                }
                buf.writeByte((byte)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public void writeVersion(ByteBuf buf, String version) {
            buf.writeBytes(version.getBytes());
        }
    }

    static enum Codec {
        HEADER{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                MessageTree tree = ctx.getMessageTree();
                String version = ctx.getVersion(buf);
                if (!NativeMessageCodec.ID.equals(version)) {
                    throw new RuntimeException(String.format("Unrecognized version(%s) for binary message codec!", version));
                }
                tree.setDomain(ctx.readString(buf));
                tree.setHostName(ctx.readString(buf));
                tree.setIpAddress(ctx.readString(buf));
                tree.setThreadGroupName(ctx.readString(buf));
                tree.setThreadId(ctx.readString(buf));
                tree.setThreadName(ctx.readString(buf));
                tree.setMessageId(ctx.readString(buf));
                tree.setParentMessageId(ctx.readString(buf));
                tree.setRootMessageId(ctx.readString(buf));
                tree.setSessionToken(ctx.readString(buf));
                return null;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                MessageTree tree = ctx.getMessageTree();
                ctx.writeVersion(buf, NativeMessageCodec.ID);
                ctx.writeString(buf, tree.getDomain());
                ctx.writeString(buf, tree.getHostName());
                ctx.writeString(buf, tree.getIpAddress());
                ctx.writeString(buf, tree.getThreadGroupName());
                ctx.writeString(buf, tree.getThreadId());
                ctx.writeString(buf, tree.getThreadName());
                ctx.writeString(buf, tree.getMessageId());
                ctx.writeString(buf, tree.getParentMessageId());
                ctx.writeString(buf, tree.getRootMessageId());
                ctx.writeString(buf, tree.getSessionToken());
            }
        }
        ,
        TRANSACTION_START{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                long timestamp = ctx.readTimestamp(buf);
                String type = ctx.readString(buf);
                String name = ctx.readString(buf);
                if ("System".equals(type) && name.startsWith("UploadMetric")) {
                    name = "UploadMetric";
                }
                DefaultTransaction t = new DefaultTransaction(type, name);
                t.setTimestamp(timestamp);
                ctx.pushTransaction(t);
                MessageTree tree = ctx.getMessageTree();
                if (tree instanceof DefaultMessageTree) {
                    ((DefaultMessageTree)tree).getTransactions().add(t);
                }
                return t;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                ctx.writeId(buf, 't');
                ctx.writeTimestamp(buf, msg.getTimestamp());
                ctx.writeString(buf, msg.getType());
                ctx.writeString(buf, msg.getName());
            }
        }
        ,
        TRANSACTION_END{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                String status = ctx.readString(buf);
                String data = ctx.readString(buf);
                long durationInMicros = ctx.readDuration(buf);
                DefaultTransaction t = ctx.popTransaction();
                t.setStatus(status);
                t.addData(data);
                t.setDurationInMicros(durationInMicros);
                return t;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                Transaction t = (Transaction)msg;
                ctx.writeId(buf, 'T');
                ctx.writeString(buf, msg.getStatus());
                ctx.writeString(buf, msg.getData().toString());
                ctx.writeDuration(buf, t.getDurationInMicros());
            }
        }
        ,
        EVENT{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                long timestamp = ctx.readTimestamp(buf);
                String type = ctx.readString(buf);
                String name = ctx.readString(buf);
                String status = ctx.readString(buf);
                String data = ctx.readString(buf);
                DefaultEvent e = new DefaultEvent(type, name);
                e.setTimestamp(timestamp);
                e.setStatus(status);
                e.addData(data);
                MessageTree tree = ctx.getMessageTree();
                if (tree instanceof DefaultMessageTree) {
                    ((DefaultMessageTree)tree).getEvents().add(e);
                }
                return e;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                ctx.writeId(buf, 'E');
                ctx.writeTimestamp(buf, msg.getTimestamp());
                ctx.writeString(buf, msg.getType());
                ctx.writeString(buf, msg.getName());
                ctx.writeString(buf, msg.getStatus());
                ctx.writeString(buf, msg.getData().toString());
            }
        }
        ,
        METRIC{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                long timestamp = ctx.readTimestamp(buf);
                String type = ctx.readString(buf);
                String name = ctx.readString(buf);
                String status = ctx.readString(buf);
                String data = ctx.readString(buf);
                DefaultMetric m = new DefaultMetric(type, name);
                m.setTimestamp(timestamp);
                m.setStatus(status);
                m.addData(data);
                MessageTree tree = ctx.getMessageTree();
                if (tree instanceof DefaultMessageTree) {
                    ((DefaultMessageTree)tree).getMetrics().add(m);
                }
                return m;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                ctx.writeId(buf, 'M');
                ctx.writeTimestamp(buf, msg.getTimestamp());
                ctx.writeString(buf, msg.getType());
                ctx.writeString(buf, msg.getName());
                ctx.writeString(buf, msg.getStatus());
                ctx.writeString(buf, msg.getData().toString());
            }
        }
        ,
        HEARTBEAT{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                long timestamp = ctx.readTimestamp(buf);
                String type = ctx.readString(buf);
                String name = ctx.readString(buf);
                String status = ctx.readString(buf);
                String data = ctx.readString(buf);
                DefaultHeartbeat h = new DefaultHeartbeat(type, name);
                h.setTimestamp(timestamp);
                h.setStatus(status);
                h.addData(data);
                MessageTree tree = ctx.getMessageTree();
                if (tree instanceof DefaultMessageTree) {
                    ((DefaultMessageTree)tree).addHeartbeat(h);
                }
                return h;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                ctx.writeId(buf, 'H');
                ctx.writeTimestamp(buf, msg.getTimestamp());
                ctx.writeString(buf, msg.getType());
                ctx.writeString(buf, msg.getName());
                ctx.writeString(buf, msg.getStatus());
                ctx.writeString(buf, msg.getData().toString());
            }
        }
        ,
        TRACE{

            @Override
            protected Message decode(Context ctx, ByteBuf buf) {
                long timestamp = ctx.readTimestamp(buf);
                String type = ctx.readString(buf);
                String name = ctx.readString(buf);
                String status = ctx.readString(buf);
                String data = ctx.readString(buf);
                DefaultTrace t = new DefaultTrace(type, name);
                t.setTimestamp(timestamp);
                t.setStatus(status);
                t.addData(data);
                return t;
            }

            @Override
            protected void encode(Context ctx, ByteBuf buf, Message msg) {
                ctx.writeId(buf, 'L');
                ctx.writeTimestamp(buf, msg.getTimestamp());
                ctx.writeString(buf, msg.getType());
                ctx.writeString(buf, msg.getName());
                ctx.writeString(buf, msg.getStatus());
                ctx.writeString(buf, msg.getData().toString());
            }
        };


        protected abstract Message decode(Context var1, ByteBuf var2);

        protected abstract void encode(Context var1, ByteBuf var2, Message var3);
    }
}

