/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.codec;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.List;

public class MessageTreeFormat {
    public void format(MessageTree tree) {
        try {
            this.formatTruncateMessage(tree);
            this.formatTransaction(tree);
        }
        catch (Exception e) {
            Cat.logError(e);
        }
    }

    private void formatTransaction(MessageTree tree) {
        List<Transaction> transactions = tree.getTransactions();
        for (Transaction t : transactions) {
            String type = t.getType();
            String name = t.getName();
            if ("URL".equals(type)) {
                this.modifyTransactionName(t, UrlParser.format(name));
                break;
            }
            if (!"System".equals(type) || !name.startsWith("UploadMetric")) continue;
            this.modifyTransactionName(t, "UploadMetric");
            break;
        }
    }

    private void formatTruncateMessage(MessageTree tree) {
        List<Event> events = tree.getEvents();
        if (!events.isEmpty()) {
            Event event = events.get(events.size() - 1);
            String type = event.getType();
            String name = event.getName();
            if ("TruncatedTransaction".equals(type) && "TotalDuration".equals(name)) {
                long delta = Long.parseLong(event.getData().toString());
                this.modifyDuration(tree, delta);
            }
        }
    }

    private void modifyDuration(MessageTree tree, long duration) {
        List<Transaction> transactions = tree.getTransactions();
        if (!transactions.isEmpty()) {
            transactions.get(0).setDurationInMillis(duration / 1000L);
            Message message = tree.getMessage();
            if (message instanceof Transaction) {
                ((Transaction)message).setDurationInMillis(duration / 1000L);
            }
        }
    }

    private void modifyTransactionName(Transaction transaction, String name) {
        if (transaction instanceof DefaultTransaction) {
            ((DefaultTransaction)transaction).setName(name);
        }
    }

    public static class UrlParser {
        public static final char SPLIT = '/';

        public static String format(String url) {
            int length = url.length();
            StringBuilder sb = new StringBuilder(length);
            int index = 0;
            block0: while (index < length) {
                char c = url.charAt(index);
                if (c == '/' && index < length - 1) {
                    sb.append(c);
                    StringBuilder nextSection = new StringBuilder();
                    boolean isNumber = false;
                    boolean first = true;
                    for (int j = index + 1; j < length; ++j) {
                        char next = url.charAt(j);
                        if ((first || isNumber) && next != '/') {
                            isNumber = UrlParser.isNumber(next);
                            first = false;
                        }
                        if (next == '/') {
                            if (isNumber) {
                                sb.append("{num}");
                            } else {
                                sb.append(nextSection.toString());
                            }
                            index = j;
                            continue block0;
                        }
                        if (j == length - 1) {
                            if (isNumber) {
                                sb.append("{num}");
                            } else {
                                nextSection.append(next);
                                sb.append(nextSection.toString());
                            }
                            index = j + 1;
                            continue block0;
                        }
                        nextSection.append(next);
                    }
                    continue;
                }
                sb.append(c);
                ++index;
            }
            return sb.toString();
        }

        public static boolean isNumber(char c) {
            return c >= '0' && c <= '9' || c == '.' || c == '-' || c == ',';
        }
    }
}

