/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.queue;

import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageTree;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class PriorityMessageQueue
implements MessageQueue {
    private BlockingQueue<MessageTree> m_highQueue;
    private BlockingQueue<MessageTree> m_nomalQueue;

    public PriorityMessageQueue(int size) {
        this.m_highQueue = new ArrayBlockingQueue<MessageTree>(size / 2);
        this.m_nomalQueue = new ArrayBlockingQueue<MessageTree>(size);
    }

    @Override
    public boolean offer(MessageTree tree) {
        if (tree.canDiscard()) {
            return this.m_nomalQueue.offer(tree);
        }
        return this.m_highQueue.offer(tree);
    }

    @Override
    public MessageTree peek() {
        MessageTree tree = (MessageTree)this.m_highQueue.peek();
        if (tree == null) {
            tree = (MessageTree)this.m_nomalQueue.peek();
        }
        return tree;
    }

    @Override
    public MessageTree poll() {
        MessageTree tree = (MessageTree)this.m_highQueue.poll();
        if (tree == null) {
            try {
                tree = this.m_nomalQueue.poll(5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return tree;
    }

    @Override
    public int size() {
        return this.m_nomalQueue.size() + this.m_highQueue.size();
    }
}

