/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.analyzer.LocalAggregator;
import com.dianping.cat.analyzer.ptest.PtestConstants;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.io.ChannelManager;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.queue.DefaultMessageQueue;
import com.dianping.cat.message.queue.PriorityMessageQueue;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageStatistics;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import com.dianping.cat.status.AbstractCollector;
import com.dianping.cat.status.StatusExtensionRegister;
import com.dianping.cat.util.MtraceTracer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class TcpSocketSender
implements Threads.Task,
MessageSender,
LogEnabled {
    @Inject(value={"NT1"})
    private MessageCodec m_nativeCodec;
    @Inject
    private MessageStatistics m_statistics;
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private MessageIdFactory m_factory;
    private MessageQueue m_messageQueue = new PriorityMessageQueue(5000);
    private AtomicMessageManager m_atomicQueueManager = new AtomicMessageManager(5000);
    private ChannelManager m_channelManager;
    private Logger m_logger;
    private boolean m_active;
    private static final int SIZE = 5000;
    private static final long HOUR = 3600000L;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getName() {
        return "TcpSocketSender";
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses) {
        this.m_channelManager = new ChannelManager(this.m_logger, addresses, this.m_configManager, this.m_factory);
        Threads.forGroup((String)"cat").start((Runnable)((Object)this));
        Threads.forGroup((String)"cat").start((Runnable)((Object)this.m_channelManager));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TcpSocketSender.this.m_logger.info("shut down cat client in runtime shut down hook!");
                TcpSocketSender.this.shutdown();
            }
        });
        StatusExtensionRegister.getInstance().register(new AbstractCollector(){

            @Override
            public String getId() {
                return "cat.status";
            }

            @Override
            public Map<String, String> getProperties() {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("cat.status.send.queue.size", String.valueOf(TcpSocketSender.this.m_messageQueue.size()));
                map.put("cat.status.send.atomic.queue.size", String.valueOf(TcpSocketSender.this.m_atomicQueueManager.getQueueSize()));
                map.put("cat.status.send.atomic.ptest.queue.size", String.valueOf(TcpSocketSender.this.m_atomicQueueManager.getPtestQueueSize()));
                Map<String, Long> values = TcpSocketSender.this.m_statistics.getStatistics();
                for (Map.Entry<String, Long> entry : values.entrySet()) {
                    map.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
                return map;
            }
        });
    }

    private void logMessageDiscard(MessageTree tree) {
        this.m_statistics.onOverflowed(tree);
    }

    private void offer(MessageTree tree, boolean isPtest) {
        boolean result;
        if (this.m_configManager.isAtomicMessage(tree)) {
            result = this.m_atomicQueueManager.offerToQueue(tree, isPtest);
        } else {
            if (isPtest) {
                tree.setDomain(PtestConstants.PERF_DOMAIN);
            }
            result = this.m_messageQueue.offer(tree);
        }
        if (!result) {
            this.processTreeInClient(tree, isPtest);
            if (!tree.canDiscard()) {
                this.logMessageDiscard(tree);
            }
        }
    }

    private void processMessage() {
        block12: {
            ChannelFuture channel = this.m_channelManager.channel();
            if (channel != null) {
                try {
                    MessageTree tree = this.m_messageQueue.poll();
                    if (tree != null) {
                        this.sendInternal(channel, tree);
                        tree.setMessage(null);
                        break block12;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception e) {
                        this.m_active = false;
                    }
                }
                catch (Throwable t) {
                    this.m_logger.error("Error when sending message over TCP socket!", t);
                }
            } else {
                long current = System.currentTimeMillis();
                long oldTimestamp = current - 3600000L;
                try {
                    MessageTree tree;
                    while ((tree = this.m_messageQueue.peek()) != null && tree.getMessage().getTimestamp() < oldTimestamp) {
                        MessageTree discradTree = this.m_messageQueue.poll();
                        if (discradTree == null) continue;
                        this.m_statistics.onOverflowed(discradTree);
                    }
                }
                catch (Exception e) {
                    this.m_logger.error(e.getMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception e) {
                    this.m_active = false;
                }
            }
        }
    }

    private void processTreeInClient(MessageTree tree, boolean isPerfTest) {
        LocalAggregator.aggregate(tree, isPerfTest);
    }

    public void run() {
        MessageTree tree;
        this.m_active = true;
        while (this.m_active) {
            this.processMessage();
            this.m_atomicQueueManager.processAtomicMessage();
        }
        this.m_atomicQueueManager.processAtomicMessage();
        while ((tree = this.m_messageQueue.poll()) != null) {
            ChannelFuture channel = this.m_channelManager.channel();
            if (channel != null) {
                this.sendInternal(channel, tree);
                continue;
            }
            this.offer(tree, false);
        }
    }

    @Override
    public void send(MessageTree tree) {
        if (!this.m_configManager.isMessageBlock()) {
            double sampleRatio = this.m_configManager.getSamplingRate();
            boolean isTest = MtraceTracer.isTest();
            if (tree.canDiscard() && sampleRatio < 1.0 && !tree.isHitSample()) {
                this.processTreeInClient(tree, isTest);
            } else {
                this.offer(tree, isTest);
            }
        }
    }

    private void sendInternal(ChannelFuture channel, MessageTree tree) {
        if (tree.getMessageId() == null) {
            tree.setMessageId(this.m_factory.getNextId());
        }
        ByteBuf buf = this.m_nativeCodec.encode(tree);
        int size = buf.readableBytes();
        channel.channel().writeAndFlush((Object)buf);
        if (this.m_statistics != null) {
            this.m_statistics.onBytes(size);
        }
    }

    public void sendMessageForTest(MessageTree tree) {
        ChannelFuture future;
        if (tree.getMessageId() == null) {
            tree.setMessageId(this.m_factory.getNextId());
        }
        if ((future = this.m_channelManager.channel()) != null) {
            ByteBuf buf = this.m_nativeCodec.encode(tree);
            int size = buf.readableBytes();
            Channel channel = future.channel();
            channel.writeAndFlush((Object)buf);
            if (this.m_statistics != null) {
                this.m_statistics.onBytes(size);
            }
        }
    }

    @Override
    public void shutdown() {
        this.m_active = false;
        this.m_channelManager.shutdown();
    }

    public class AtomicMessageManager {
        private MessageQueue m_smallMessages;
        private MessageQueue m_perfTestSmallMessages;
        private static final long HOUR = 3600000L;
        private static final int MAX_CHILD_NUMBER = 200;
        private static final int MAX_DURATION = 30000;

        public AtomicMessageManager(int size) {
            this.m_smallMessages = new DefaultMessageQueue(size);
            this.m_perfTestSmallMessages = new DefaultMessageQueue(size);
        }

        public int getPtestQueueSize() {
            return this.m_perfTestSmallMessages.size();
        }

        public int getQueueSize() {
            return this.m_smallMessages.size();
        }

        private boolean isSameHour(long time1, long time2) {
            int hour1 = (int)(time1 / 3600000L);
            int hour2 = (int)(time2 / 3600000L);
            return hour1 == hour2;
        }

        private MessageTree mergeTree(MessageQueue queue) {
            long nextTimestamp;
            MessageTree tree;
            DefaultTransaction t = new DefaultTransaction("System", "AtomicAggregator");
            MessageTree first = queue.poll();
            Message message = first.getMessage();
            long timestamp = message.getTimestamp();
            t.setStatus("0");
            t.setCompleted(true);
            t.setDurationStart(timestamp);
            t.setTimestamp(timestamp);
            t.setDurationInMicros(0L);
            t.addChild(message);
            for (int max = 200; max >= 0 && (tree = queue.peek()) != null && this.isSameHour(timestamp, nextTimestamp = tree.getMessage().getTimestamp()) && (tree = queue.poll()) != null; --max) {
                t.addChild(tree.getMessage());
            }
            ((DefaultMessageTree)first).setMessage(t);
            return first;
        }

        public boolean offerToQueue(MessageTree tree, boolean isPtest) {
            boolean result = isPtest ? this.m_perfTestSmallMessages.offer(tree) : this.m_smallMessages.offer(tree);
            return result;
        }

        public void processAtomicMessage() {
            this.processNormalAtomicMessage();
            this.processPerfAtomicMessage();
        }

        private void processNormalAtomicMessage() {
            while (this.shouldMerge(this.m_smallMessages)) {
                MessageTree tree = this.mergeTree(this.m_smallMessages);
                TcpSocketSender.this.offer(tree, false);
            }
        }

        private void processPerfAtomicMessage() {
            while (this.shouldMerge(this.m_perfTestSmallMessages)) {
                MessageTree tree = this.mergeTree(this.m_perfTestSmallMessages);
                TcpSocketSender.this.offer(tree, true);
            }
        }

        private boolean shouldMerge(MessageQueue queue) {
            MessageTree tree = queue.peek();
            if (tree != null) {
                long firstTime = tree.getMessage().getTimestamp();
                if (System.currentTimeMillis() - firstTime > 30000L || queue.size() >= 200) {
                    return true;
                }
            }
            return false;
        }
    }
}

