/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.io.TcpSocketSender;
import com.dianping.cat.message.io.TransportManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TransportManager.class)
public class DefaultTransportManager
implements TransportManager,
Initializable,
LogEnabled {
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private TcpSocketSender m_tcpSocketSender;
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public MessageSender getSender() {
        return this.m_tcpSocketSender;
    }

    public void initialize() {
        List<Server> servers = this.m_configManager.getServers();
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (Server server : servers) {
            if (!server.isEnabled()) continue;
            addresses.add(new InetSocketAddress(server.getIp(), server.getPort()));
        }
        this.m_logger.info("Remote CAT servers: " + addresses);
        if (addresses.isEmpty()) {
            this.m_logger.error("All servers in configuration are disabled!\r\n" + servers);
        } else {
            this.m_tcpSocketSender.initialize(addresses);
        }
    }
}

