/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.unidal.helper.Splitters;

public class MessageIdFactory {
    private volatile long m_timestamp = this.getTimestamp();
    private volatile AtomicInteger m_index = new AtomicInteger(0);
    private String m_domain = "UNKNOWN";
    private String m_ipAddress;
    private MappedByteBuffer m_byteBuffer;
    private RandomAccessFile m_markFile;
    private Map<String, AtomicInteger> m_map = new ConcurrentHashMap<String, AtomicInteger>(100);
    private int m_retry;
    public static final long HOUR = 3600000L;

    public void close() {
        try {
            this.saveMark();
            this.m_markFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File createMarkFile(String domain) {
        File mark = new File(Cat.getCatHome(), "cat-" + domain + ".mark");
        if (!mark.exists()) {
            boolean success = true;
            try {
                success = mark.createNewFile();
            }
            catch (Exception e) {
                success = false;
            }
            if (!success) {
                mark = this.createTempFile(domain);
            }
        } else if (!mark.canWrite()) {
            mark = this.createTempFile(domain);
        }
        return mark;
    }

    private File createTempFile(String domain) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File mark = new File(tmpDir, "cat-" + domain + ".mark");
        return mark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextId() {
        long timestamp = this.getTimestamp();
        if (timestamp != this.m_timestamp) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (timestamp != this.m_timestamp) {
                    this.resetCounter(timestamp);
                }
            }
        }
        int index = this.m_index.getAndIncrement();
        StringBuilder sb = new StringBuilder(this.m_domain.length() + 32);
        sb.append(this.m_domain).append('-').append(this.m_ipAddress).append('-').append(timestamp).append('-').append(index);
        return sb.toString();
    }

    public String getNextId(String domain) {
        return this.getNextId();
    }

    protected long getTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp / 3600000L;
    }

    public void initialize(String domain) throws IOException {
        block8: {
            String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
            List items = Splitters.by((String)".").noEmptyItem().split(ip);
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytes[i] = (byte)Integer.parseInt((String)items.get(i));
            }
            StringBuilder sb = new StringBuilder(bytes.length / 2);
            for (byte b : bytes) {
                sb.append(Integer.toHexString(b >> 4 & 0xF));
                sb.append(Integer.toHexString(b & 0xF));
            }
            this.m_domain = domain;
            this.m_ipAddress = sb.toString();
            File mark = this.createMarkFile(domain);
            this.m_markFile = new RandomAccessFile(mark, "rw");
            this.m_byteBuffer = this.m_markFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
            if (this.m_byteBuffer.limit() > 0) {
                try {
                    long lastTimestamp = this.m_byteBuffer.getLong();
                    int index = this.m_byteBuffer.getInt();
                    if (lastTimestamp == this.m_timestamp) {
                        this.m_index = new AtomicInteger(index + 1000);
                        int mapLength = this.m_byteBuffer.getInt();
                        for (int i = 0; i < mapLength; ++i) {
                            int domainLength = this.m_byteBuffer.getInt();
                            byte[] domainArray = new byte[domainLength];
                            this.m_byteBuffer.get(domainArray);
                            int value = this.m_byteBuffer.getInt();
                            this.m_map.put(new String(domainArray), new AtomicInteger(value + 1000));
                        }
                    } else {
                        this.m_index = new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    ++this.m_retry;
                    if (this.m_retry != 1) break block8;
                    mark.delete();
                    this.initialize(domain);
                }
            }
        }
        this.saveMark();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MessageIdFactory.this.close();
            }
        });
    }

    private void resetCounter(long timestamp) {
        this.m_index.set(0);
        for (Map.Entry<String, AtomicInteger> entry : this.m_map.entrySet()) {
            entry.getValue().set(0);
        }
        this.m_timestamp = timestamp;
    }

    public synchronized void saveMark() {
        try {
            this.m_byteBuffer.rewind();
            this.m_byteBuffer.putLong(this.m_timestamp);
            this.m_byteBuffer.putInt(this.m_index.get());
            this.m_byteBuffer.putInt(this.m_map.size());
            for (Map.Entry<String, AtomicInteger> entry : this.m_map.entrySet()) {
                byte[] bytes = entry.getKey().toString().getBytes();
                this.m_byteBuffer.putInt(bytes.length);
                this.m_byteBuffer.put(bytes);
                this.m_byteBuffer.putInt(entry.getValue().get());
            }
            this.m_byteBuffer.force();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }
}

