/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

public class MessageId {
    private String m_domain;
    private String m_ipAddressInHex;
    private int m_hour;
    private int m_index;

    public static MessageId parse(String messageId) {
        int index = -1;
        int hour = -1;
        String ipAddressInHex = null;
        String domain = null;
        int len = messageId.length();
        int part = 4;
        int end = len;
        block5: for (int i = len - 1; i >= 0; --i) {
            char ch = messageId.charAt(i);
            if (ch != '-') continue;
            switch (part) {
                case 4: {
                    index = Integer.parseInt(messageId.substring(i + 1, end));
                    end = i;
                    --part;
                    continue block5;
                }
                case 3: {
                    hour = Integer.parseInt(messageId.substring(i + 1, end));
                    end = i;
                    --part;
                    continue block5;
                }
                case 2: {
                    ipAddressInHex = messageId.substring(i + 1, end);
                    domain = messageId.substring(0, i);
                    --part;
                    continue block5;
                }
            }
        }
        if (domain == null || ipAddressInHex == null || hour < 0 || index < 0) {
            throw new RuntimeException("Invalid message ID format: " + messageId);
        }
        return new MessageId(domain, ipAddressInHex, hour, index);
    }

    public MessageId(String domain, String ipAddressInHex, int hour, int index) {
        this.m_domain = domain;
        this.m_ipAddressInHex = ipAddressInHex;
        this.m_hour = hour;
        this.m_index = index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageId) {
            MessageId o = (MessageId)obj;
            if (!this.m_domain.equals(o.m_domain)) {
                return false;
            }
            if (!this.m_ipAddressInHex.equals(o.m_ipAddressInHex)) {
                return false;
            }
            if (this.m_hour != o.m_hour) {
                return false;
            }
            return this.m_index == o.m_index;
        }
        return false;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getIndex() {
        return this.m_index;
    }

    public String getIpAddress() {
        StringBuilder sb = new StringBuilder();
        String local = this.m_ipAddressInHex;
        int length = local.length();
        for (int i = 0; i < length; i += 2) {
            char ch1 = local.charAt(i);
            char ch2 = local.charAt(i + 1);
            int value = 0;
            value = ch1 >= '0' && ch1 <= '9' ? (value += ch1 - 48 << 4) : (value += ch1 - 97 + 10 << 4);
            value = ch2 >= '0' && ch2 <= '9' ? (value += ch2 - 48) : (value += ch2 - 97 + 10);
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public String getIpAddressInHex() {
        return this.m_ipAddressInHex;
    }

    public int getIpAddressValue() {
        String local = this.m_ipAddressInHex;
        int length = local.length();
        int ip = 0;
        for (int i = 0; i < length; i += 2) {
            char ch1 = local.charAt(i);
            char ch2 = local.charAt(i + 1);
            int value = 0;
            value = ch1 >= '0' && ch1 <= '9' ? (value += ch1 - 48 << 4) : (value += ch1 - 97 + 10 << 4);
            value = ch2 >= '0' && ch2 <= '9' ? (value += ch2 - 48) : (value += ch2 - 97 + 10);
            ip = (ip << 8) + value;
        }
        return ip;
    }

    public long getTimestamp() {
        return (long)(this.m_hour * 3600) * 1000L;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        result = 31 * result + (this.m_ipAddressInHex == null ? 0 : this.m_ipAddressInHex.hashCode());
        result = 31 * result + this.m_hour;
        result = 31 * result + this.m_index;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_domain.length() + 30);
        sb.append(this.m_domain);
        sb.append('-');
        sb.append(this.m_ipAddressInHex);
        sb.append('-');
        sb.append(this.m_hour);
        sb.append('-');
        sb.append(this.m_index);
        return sb.toString();
    }
}

