/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultForkedTransaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.io.TransportManager;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=MessageManager.class)
public class DefaultMessageManager
extends ContainerHolder
implements MessageManager,
Initializable,
LogEnabled {
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private TransportManager m_transportManager;
    @Inject
    private MessageIdFactory m_factory;
    private AtomicInteger m_sampleCount = new AtomicInteger();
    private ThreadLocal<Context> m_context = new ThreadLocal();
    private long m_throttleTimes;
    private String m_domain;
    private String m_hostName;
    private boolean m_firstMessage = true;
    private TransactionHelper m_validator = new TransactionHelper();
    private Logger m_logger;
    private String m_ip;

    @Override
    public void add(Message message) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.add(message);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void end(Transaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null && transaction.isStandalone() && ctx.end(this, transaction)) {
            this.m_context.remove();
        }
    }

    public void flush(MessageTree tree, boolean clearContext) {
        MessageSender sender = this.m_transportManager.getSender();
        if (sender != null) {
            sender.send(tree);
            if (clearContext) {
                this.reset();
            }
        } else {
            ++this.m_throttleTimes;
            if (this.m_throttleTimes % 10000L == 0L || this.m_throttleTimes == 1L) {
                this.m_logger.info("Cat Message is throttled! Times:" + this.m_throttleTimes);
            }
        }
    }

    @Override
    public ClientConfigManager getConfigManager() {
        return this.m_configManager;
    }

    private boolean hitSample(double sampleRatio) {
        int count = this.m_sampleCount.incrementAndGet();
        return count % (int)(1.0 / sampleRatio) == 0;
    }

    @Override
    public Context getContext() {
        Context ctx = this.m_context.get();
        if (ctx != null) {
            return ctx;
        }
        ctx = new Context(this.m_domain, this.m_hostName, this.m_ip);
        this.m_context.set(ctx);
        return ctx;
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    public String getMetricType() {
        return "";
    }

    @Override
    public Transaction getPeekTransaction() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.peekTransaction();
        }
        return null;
    }

    private MessageManager getManager() {
        return this;
    }

    @Override
    public MessageTree getThreadLocalMessageTree() {
        Context ctx = this.m_context.get();
        if (ctx == null) {
            this.setup();
        }
        ctx = this.m_context.get();
        return ctx.m_tree;
    }

    @Override
    public boolean hasContext() {
        MessageTree tree;
        boolean has;
        Context context = this.m_context.get();
        boolean bl = has = context != null;
        if (has && (tree = context.m_tree) == null) {
            return false;
        }
        return has;
    }

    public void initialize() {
        this.m_domain = String.valueOf(this.m_configManager.getDomain());
        this.m_hostName = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        this.m_ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        try {
            this.m_factory.initialize(this.m_domain);
        }
        catch (Exception e) {
            this.m_logger.error("error when create mark file", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public boolean isCatEnabled() {
        return true;
    }

    @Override
    @Deprecated
    public boolean isMessageEnabled() {
        return true;
    }

    @Override
    public boolean isTraceMode() {
        Context content = this.getContext();
        if (content != null) {
            return content.isTraceMode();
        }
        return false;
    }

    private String nextMessageId() {
        return this.m_factory.getNextId();
    }

    public boolean notExsitCause(Throwable e) {
        Context ctx = this.m_context.get();
        if (ctx != null) {
            return ctx.notExsitCause(e);
        }
        return true;
    }

    @Override
    public void reset() {
        Context ctx = this.m_context.get();
        if (ctx != null) {
            if (ctx.m_totalDurationInMicros == 0L) {
                ctx.clear();
                this.m_context.remove();
            } else {
                ctx.m_knownExceptions.clear();
            }
        }
    }

    public void setMetricType(String metricType) {
    }

    @Override
    public void setTraceMode(boolean traceMode) {
        Context context = this.getContext();
        if (context != null) {
            context.setTraceMode(traceMode);
        }
    }

    @Override
    public void setup() {
        Context ctx = new Context(this.m_domain, this.m_hostName, this.m_ip);
        double samplingRate = this.m_configManager.getSamplingRate();
        if (samplingRate < 1.0 && this.hitSample(samplingRate)) {
            ctx.m_tree.setHitSample(true);
        }
        this.m_context.set(ctx);
    }

    @Override
    public void start(Transaction transaction, boolean forked) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.start(transaction, forked);
        } else if (this.m_firstMessage) {
            this.m_firstMessage = false;
            this.m_logger.warn("CAT client is not enabled because it's not initialized yet");
        }
    }

    class TransactionHelper {
        TransactionHelper() {
        }

        protected void markAsNotCompleted(DefaultTransaction transaction) {
            transaction.setCompleted(true);
        }

        private void migrateMessage(Stack<Transaction> stack, Transaction source, Transaction target, int level) {
            Transaction current = level < stack.size() ? (Transaction)stack.get(level) : null;
            boolean shouldKeep = false;
            List<Message> childs = source.getChildren();
            for (Message child : childs) {
                if (child != current) {
                    target.addChild(child);
                    continue;
                }
                DefaultTransaction cloned = new DefaultTransaction(current.getType(), current.getName(), DefaultMessageManager.this);
                cloned.setTimestamp(current.getTimestamp());
                cloned.setDurationInMicros(current.getDurationInMicros());
                cloned.addData(current.getData().toString());
                cloned.setStatus("0");
                target.addChild(cloned);
                this.migrateMessage(stack, current, cloned, level + 1);
                shouldKeep = true;
            }
            source.getChildren().clear();
            if (shouldKeep) {
                source.addChild(current);
            }
        }

        public void truncateAndFlush(Context ctx, long timestamp) {
            MessageTree tree = ctx.m_tree;
            List<ForkableTransaction> forkableTransactions = tree.getForkableTransactions();
            Stack stack = ctx.m_stack;
            Message message = tree.getMessage();
            if (message instanceof DefaultTransaction || message instanceof DefaultForkedTransaction) {
                Object t;
                for (ForkableTransaction forkableTransaction : forkableTransactions) {
                    forkableTransaction.complete();
                }
                String id = tree.getMessageId();
                if (id == null) {
                    id = DefaultMessageManager.this.nextMessageId();
                    tree.setMessageId(id);
                }
                String rootId = tree.getRootMessageId();
                String childId = DefaultMessageManager.this.nextMessageId();
                Transaction source = (Transaction)message;
                DefaultTransaction target = new DefaultTransaction(source.getType(), source.getName(), DefaultMessageManager.this);
                target.setTimestamp(source.getTimestamp());
                target.setDurationInMicros(source.getDurationInMicros());
                target.addData(source.getData().toString());
                target.setStatus("0");
                this.migrateMessage(stack, source, target, 1);
                for (int i = stack.size() - 1; i >= 0; --i) {
                    if (stack.get(i) instanceof DefaultTransaction) {
                        t = (DefaultTransaction)stack.get(i);
                        ((AbstractMessage)t).setTimestamp(timestamp);
                        ((DefaultTransaction)t).setDurationStart(System.nanoTime());
                        continue;
                    }
                    if (!(stack.get(i) instanceof DefaultForkedTransaction)) continue;
                    t = (DefaultForkedTransaction)stack.get(i);
                    ((AbstractMessage)t).setTimestamp(timestamp);
                    ((DefaultForkedTransaction)t).SetDurationInMicros(System.nanoTime() / 1000L);
                    if (i != 0) continue;
                    ArrayList<Message> temp = new ArrayList<Message>();
                    DefaultEvent parent = new DefaultEvent("RemoteCall", "Next");
                    parent.addData(id);
                    parent.setStatus("0");
                    temp.add(parent);
                    temp.addAll(((DefaultForkedTransaction)t).getChildren());
                    ((DefaultForkedTransaction)t).getChildren().clear();
                    ((DefaultForkedTransaction)t).getChildren().addAll(temp);
                }
                DefaultEvent next = new DefaultEvent("RemoteCall", "Next");
                next.addData(childId);
                next.setStatus("0");
                target.addChild(next);
                t = tree.copy();
                t.setMessage(target);
                ctx.m_tree.setMessageId(childId);
                ctx.m_tree.setParentMessageId(id);
                ctx.m_tree.setRootMessageId(rootId != null ? rootId : id);
                ctx.m_tree.getForkableTransactions().clear();
                ctx.m_length = stack.size();
                ctx.m_totalDurationInMicros = ctx.m_totalDurationInMicros + target.getDurationInMicros();
                DefaultMessageManager.this.flush((MessageTree)t, false);
            }
        }
    }

    public class Context {
        private MessageTree m_tree = new DefaultMessageTree();
        private Stack<Transaction> m_stack = new Stack();
        private int m_length;
        private boolean m_traceMode;
        private long m_totalDurationInMicros;
        private Set<Throwable> m_knownExceptions;

        public Context(String domain, String hostName, String ipAddress) {
            Thread thread = Thread.currentThread();
            String groupName = thread.getThreadGroup().getName();
            this.m_tree.setThreadGroupName(groupName);
            this.m_tree.setThreadId(String.valueOf(thread.getId()));
            this.m_tree.setThreadName(thread.getName());
            this.m_tree.setDomain(domain);
            this.m_tree.setHostName(hostName);
            this.m_tree.setIpAddress(ipAddress);
            this.m_length = 1;
        }

        public void attach(ForkedTransaction forked) {
            if (this.m_stack.isEmpty()) {
                this.m_stack.push(forked);
                this.m_tree.setMessage(forked);
            }
        }

        public void detach(String rootMessageId, String parentMessageId) {
            if (this.m_stack.firstElement() instanceof ForkedTransaction) {
                ForkedTransaction forked = (ForkedTransaction)this.m_stack.pop();
                if (parentMessageId != null) {
                    MessageTree tree = this.m_tree.copy();
                    if (rootMessageId == null) {
                        rootMessageId = parentMessageId;
                    }
                    tree.setRootMessageId(rootMessageId);
                    tree.setParentMessageId(parentMessageId);
                    tree.setMessageId(forked.getMessageId());
                    tree.setMessage(forked);
                    MessageManager manager = DefaultMessageManager.this.getManager();
                    if (manager instanceof DefaultMessageManager) {
                        ((DefaultMessageManager)manager).flush(tree, true);
                    }
                }
            }
        }

        public void add(Message message) {
            if (this.m_stack.isEmpty()) {
                MessageTree tree = this.m_tree.copy();
                tree.setMessage(message);
                DefaultMessageManager.this.flush(tree, true);
            } else {
                Transaction parent = this.m_stack.peek();
                this.addTransactionChild(message, parent);
            }
        }

        private void addTransactionChild(Message message, Transaction transaction) {
            long messagePeriod;
            long treePeriod = this.trimToHour(this.m_tree.getMessage().getTimestamp());
            if (treePeriod < (messagePeriod = this.trimToHour(message.getTimestamp() - 10000L)) || this.m_length >= DefaultMessageManager.this.m_configManager.getMaxMessageChildren()) {
                DefaultMessageManager.this.m_validator.truncateAndFlush(this, message.getTimestamp());
            }
            transaction.addChild(message);
            ++this.m_length;
        }

        public void addForkableTransaction(ForkableTransaction forkableTransaction) {
            this.m_tree.addForkableTransaction(forkableTransaction);
        }

        private void adjustForTruncatedTransaction(Transaction root) {
            DefaultEvent next = new DefaultEvent("TruncatedTransaction", "TotalDuration");
            long actualDurationInMicros = this.m_totalDurationInMicros + root.getDurationInMicros();
            next.addData(String.valueOf(actualDurationInMicros));
            next.setStatus("0");
            root.addChild(next);
            this.m_totalDurationInMicros = 0L;
        }

        public boolean end(DefaultMessageManager manager, Transaction transaction) {
            if (!this.m_stack.isEmpty()) {
                Transaction current = this.m_stack.pop();
                if (transaction != current) {
                    while (transaction != current && !this.m_stack.empty()) {
                        current = this.m_stack.pop();
                    }
                }
                if (this.m_stack.isEmpty()) {
                    if (!this.m_tree.getForkableTransactions().isEmpty()) {
                        for (ForkableTransaction forkableTransaction : this.m_tree.getForkableTransactions()) {
                            forkableTransaction.complete();
                        }
                    }
                    MessageTree tree = this.m_tree.copy();
                    this.m_tree.setMessageId(null);
                    this.m_tree.setMessage(null);
                    if (this.m_totalDurationInMicros > 0L) {
                        this.adjustForTruncatedTransaction((Transaction)tree.getMessage());
                        tree.setDiscard(false);
                    }
                    manager.flush(tree, true);
                    return true;
                }
            }
            return false;
        }

        public boolean isTraceMode() {
            return this.m_traceMode;
        }

        public void clear() {
            if (this.m_knownExceptions != null) {
                this.m_knownExceptions.clear();
            }
            this.m_stack.clear();
        }

        public boolean notExsitCause(Throwable e) {
            if (this.m_knownExceptions == null) {
                this.m_knownExceptions = new HashSet<Throwable>();
            }
            if (this.m_knownExceptions.contains(e)) {
                return false;
            }
            this.m_knownExceptions.add(e);
            return true;
        }

        public Transaction peekTransaction() {
            if (this.m_stack.isEmpty()) {
                return null;
            }
            return this.m_stack.peek();
        }

        public void setTraceMode(boolean traceMode) {
            this.m_traceMode = traceMode;
        }

        public void start(Transaction transaction, boolean forked) {
            if (!this.m_stack.isEmpty()) {
                if (!(transaction instanceof ForkedTransaction)) {
                    Transaction parent = this.m_stack.peek();
                    this.addTransactionChild(transaction, parent);
                }
            } else {
                this.m_tree.setMessage(transaction);
            }
            if (!forked) {
                this.m_stack.push(transaction);
            }
        }

        private long trimToHour(long timestamp) {
            return timestamp - timestamp % 3600000L;
        }
    }
}

