/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultForkableTransaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultForkedTransaction
extends AbstractMessage
implements ForkedTransaction {
    private String m_rootMessageId;
    private String m_parentMessageId;
    private String m_messageId;
    private long m_durationInMicros;
    private List<Message> m_children;
    private AtomicBoolean m_joined = new AtomicBoolean();

    public DefaultForkedTransaction(String rootMessageId, String parentMessageId) {
        super("System", "ChildThread");
        this.m_rootMessageId = rootMessageId;
        this.m_parentMessageId = parentMessageId;
        this.m_durationInMicros = System.nanoTime() / 1000L;
        this.addData(Thread.currentThread().getName());
        this.setStatus("0");
    }

    @Override
    public Transaction addChild(Message message) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Message>();
        }
        this.m_children.add(message);
        return this;
    }

    @Override
    public synchronized void complete() {
        if (!this.isCompleted()) {
            long end = System.nanoTime();
            this.m_durationInMicros = end / 1000L - this.m_durationInMicros;
            super.setCompleted(true);
            if (this.m_joined.get()) {
                this.setName("Async.Detached." + this.getName());
                Cat.getManager().getContext().detach(this.m_rootMessageId, this.m_parentMessageId);
            } else {
                this.setName("Sync.Embedded." + this.getName());
                Cat.getManager().getContext().detach(null, null);
            }
        }
    }

    @Override
    public List<Message> getChildren() {
        if (this.m_children == null) {
            return Collections.emptyList();
        }
        return this.m_children;
    }

    @Override
    public long getDurationInMicros() {
        if (super.isCompleted()) {
            return this.m_durationInMicros;
        }
        return -1L;
    }

    @Override
    public long getDurationInMillis() {
        if (super.isCompleted()) {
            return this.m_durationInMicros / 1000L;
        }
        return -1L;
    }

    public void SetDurationInMicros(long duration) {
        this.m_durationInMicros = duration;
    }

    @Override
    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public ForkableTransaction forFork() {
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        String rootMessageId = tree.getRootMessageId();
        if (tree.getMessageId() == null) {
            tree.setMessageId(Cat.createMessageId());
        }
        DefaultForkableTransaction forkable = new DefaultForkableTransaction(rootMessageId, tree.getMessageId());
        this.addChild(forkable);
        Cat.getManager().getContext().addForkableTransaction(forkable);
        return forkable;
    }

    @Override
    public void close() {
        this.complete();
    }

    @Override
    public String getMessageId() {
        return this.m_messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.m_messageId = messageId;
    }

    @Override
    public synchronized Message join() {
        this.m_joined.set(true);
        if (this.isCompleted()) {
            return this;
        }
        if (this.m_messageId == null) {
            String messageId = Cat.createMessageId();
            this.setMessageId(messageId);
        }
        DefaultEvent event = new DefaultEvent("RemoteCall", "RunAway");
        event.addData(this.m_messageId, this.getType() + ":" + this.getName());
        event.setTimestamp(this.getTimestamp());
        event.setStatus("0");
        return event;
    }

    @Override
    public void setDurationInMillis(long duration) {
        this.m_durationInMicros = duration;
    }
}

