/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.ForkableTransaction;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultForkedTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultForkableTransaction
extends AbstractMessage
implements ForkableTransaction {
    private String m_rootMessageId;
    private String m_parentMessageId;
    private long m_durationInMicros;
    private List<Message> m_children = Collections.synchronizedList(new ArrayList());

    public DefaultForkableTransaction(String rootMessageId, String parentMessageId) {
        super("System", "Forkable");
        this.m_rootMessageId = rootMessageId;
        this.m_parentMessageId = parentMessageId;
        this.m_durationInMicros = System.nanoTime() / 1000L;
        this.setStatus("0");
        this.addData("thread-name=" + DefaultForkableTransaction.generateThreadName());
    }

    @Override
    public Transaction addChild(Message message) {
        this.m_children.add(message);
        return this;
    }

    @Override
    public synchronized void complete() {
        if (!this.isCompleted()) {
            super.setCompleted(true);
            long end = System.nanoTime();
            this.m_durationInMicros = end / 1000L - this.m_durationInMicros;
            super.setCompleted(true);
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                Message child = this.m_children.get(i);
                ForkedTransaction forked = (ForkedTransaction)child;
                this.m_children.set(i, forked.join());
            }
        }
    }

    @Override
    public List<Message> getChildren() {
        return this.m_children;
    }

    @Override
    public long getDurationInMicros() {
        if (super.isCompleted()) {
            return this.m_durationInMicros;
        }
        return 0L;
    }

    @Override
    public long getDurationInMillis() {
        if (super.isCompleted()) {
            return this.m_durationInMicros / 1000L;
        }
        return 0L;
    }

    @Override
    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public ForkableTransaction forFork() {
        return this;
    }

    @Override
    public synchronized ForkedTransaction doFork() {
        DefaultForkedTransaction child = new DefaultForkedTransaction(this.m_rootMessageId, this.m_parentMessageId);
        if (this.isCompleted()) {
            this.m_children.add(child.join());
        } else {
            this.m_children.add(child);
        }
        Cat.getManager().getContext().attach(child);
        return child;
    }

    @Override
    public void setDurationInMillis(long durationInMillis) {
        this.m_durationInMicros = durationInMillis * 1000L;
    }

    private static String generateThreadName() {
        int index;
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("qtp") && (index = threadName.indexOf(" ")) > -1) {
            threadName = threadName.substring(0, index);
        }
        if (threadName.length() > 80) {
            threadName = "ThreadID-" + String.valueOf(Thread.currentThread().getId());
        }
        return threadName;
    }
}

