/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.LogbackException;
import com.dianping.cat.Cat;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CatLogbackAppender
extends AppenderBase<ILoggingEvent> {
    protected void append(ILoggingEvent event) {
        try {
            boolean isTraceMode = Cat.getManager().isTraceMode();
            Level level = event.getLevel();
            if (level.isGreaterOrEqual(Level.ERROR)) {
                this.logError(event);
            } else if (isTraceMode) {
                this.logTrace(event);
            }
        }
        catch (Exception ex) {
            throw new LogbackException(event.getFormattedMessage(), (Throwable)ex);
        }
    }

    private void logError(ILoggingEvent event) {
        ThrowableProxy info = (ThrowableProxy)event.getThrowableProxy();
        if (info != null) {
            Throwable exception = info.getThrowable();
            String message = event.getFormattedMessage();
            if (message != null) {
                Cat.logError(String.valueOf(message), exception);
            } else {
                Cat.logError(exception);
            }
        }
    }

    private void logTrace(ILoggingEvent event) {
        String type = "Logback";
        String name = event.getLevel().toString();
        String message = event.getFormattedMessage();
        String data = message instanceof Throwable ? this.buildExceptionStack((Throwable)((Object)message)) : event.getFormattedMessage().toString();
        ThrowableProxy info = (ThrowableProxy)event.getThrowableProxy();
        if (info != null) {
            data = data + '\n' + this.buildExceptionStack(info.getThrowable());
        }
        Cat.logTrace(type, name, "0", data);
    }

    private String buildExceptionStack(Throwable exception) {
        if (exception != null) {
            StringWriter writer = new StringWriter(2048);
            exception.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
        return "";
    }
}

