/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.log4j;

import com.dianping.cat.Cat;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;

@Plugin(name="CatAppender", category="Core", elementType="appender", printObject=true)
public class Log4j2Appender
extends AbstractAppender {
    private static final long serialVersionUID = 2705802038361151598L;

    protected Log4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        block5: {
            try {
                boolean isTraceMode = Cat.getManager().isTraceMode();
                Level level = event.getLevel();
                if (level.isMoreSpecificThan(Level.ERROR)) {
                    this.logError(event);
                } else if (isTraceMode) {
                    this.logTrace(event);
                }
            }
            catch (Exception ex) {
                if (this.ignoreExceptions()) break block5;
                throw new AppenderLoggingException((Throwable)ex);
            }
        }
    }

    @PluginFactory
    public static Log4j2Appender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
        if (name == null) {
            LOGGER.error("No name provided for Log4j2Appender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new Log4j2Appender(name, filter, (Layout<? extends Serializable>)layout, true);
    }

    private void logError(LogEvent event) {
        ThrowableProxy info = event.getThrownProxy();
        if (info != null) {
            Throwable exception = info.getThrowable();
            Message message = event.getMessage();
            if (message != null) {
                Cat.logError(String.valueOf(message), exception);
            } else {
                Cat.logError(exception);
            }
        }
    }

    private void logTrace(LogEvent event) {
        String type = "Log4j2";
        String name = event.getLevel().toString();
        Message message = event.getMessage();
        String data = message instanceof Throwable ? this.buildExceptionStack((Throwable)message) : event.getMessage().toString();
        ThrowableProxy info = event.getThrownProxy();
        if (info != null) {
            data = data + '\n' + this.buildExceptionStack(info.getThrowable());
        }
        Cat.logTrace(type, name, "0", data);
    }

    private String buildExceptionStack(Throwable exception) {
        if (exception != null) {
            StringWriter writer = new StringWriter(2048);
            exception.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
        return "";
    }
}

