/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;

public class Server
extends BaseEntity<Server> {
    private String m_ip;
    private int m_port = 2280;
    private int m_httpPort = 8080;
    private boolean m_enabled = true;

    public Server() {
    }

    public Server(String ip) {
        this.m_ip = ip;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitServer(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Server) {
            Server _o = (Server)obj;
            String ip = _o.getIp();
            return this.m_ip == ip || this.m_ip != null && this.m_ip.equals(ip);
        }
        return false;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public int getHttpPort() {
        return this.m_httpPort;
    }

    public String getIp() {
        return this.m_ip;
    }

    public int getPort() {
        return this.m_port;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_ip == null ? 0 : this.m_ip.hashCode());
        return hash;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void mergeAttributes(Server other) {
        this.assertAttributeEquals(other, "server", "ip", this.m_ip, other.getIp());
        this.m_port = other.getPort();
        this.m_httpPort = other.getHttpPort();
        this.m_enabled = other.getEnabled();
    }

    public Server setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        return this;
    }

    public Server setHttpPort(int httpPort) {
        this.m_httpPort = httpPort;
        return this;
    }

    public Server setIp(String ip) {
        this.m_ip = ip;
        return this;
    }

    public Server setPort(int port) {
        this.m_port = port;
        return this;
    }
}

