/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.entity;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClientConfig
extends BaseEntity<ClientConfig> {
    private String m_mode;
    private boolean m_enabled = true;
    private Boolean m_dumpLocked;
    private List<Server> m_servers = new ArrayList<Server>();
    private Map<String, Domain> m_domains = new LinkedHashMap<String, Domain>();
    private Bind m_bind;
    private List<Property> m_properties = new ArrayList<Property>();
    private String m_domain = "unknown";
    private int m_maxMessageSize = 5000;

    public ClientConfig() {
    }

    public ClientConfig(String domain) {
        if (domain != null) {
            this.m_domain = domain;
        }
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfig(this);
    }

    public ClientConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public ClientConfig addProperty(Property property) {
        this.m_properties.add(property);
        return this;
    }

    public ClientConfig addServer(Server server) {
        this.m_servers.add(server);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientConfig) {
            ClientConfig _o = (ClientConfig)obj;
            String domain = _o.getDomain();
            return this.m_domain == domain || this.m_domain != null && this.m_domain.equals(domain);
        }
        return false;
    }

    public Domain findDomain(String id) {
        return this.m_domains.get(id);
    }

    public Server findServer(String ip) {
        for (Server server : this.m_servers) {
            if (!server.getIp().equals(ip)) continue;
            return server;
        }
        return null;
    }

    public Bind getBind() {
        return this.m_bind;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Boolean getDumpLocked() {
        return this.m_dumpLocked;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public int getMaxMessageSize() {
        return this.m_maxMessageSize;
    }

    public String getMode() {
        return this.m_mode;
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    public List<Server> getServers() {
        return this.m_servers;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        return hash;
    }

    public boolean isDumpLocked() {
        return this.m_dumpLocked != null && this.m_dumpLocked != false;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void mergeAttributes(ClientConfig other) {
        this.assertAttributeEquals(other, "config", "domain", this.m_domain, other.getDomain());
        if (other.getMode() != null) {
            this.m_mode = other.getMode();
        }
        this.m_enabled = other.getEnabled();
        if (other.getDumpLocked() != null) {
            this.m_dumpLocked = other.getDumpLocked();
        }
        this.m_maxMessageSize = other.getMaxMessageSize();
    }

    public boolean removeDomain(String id) {
        if (this.m_domains.containsKey(id)) {
            this.m_domains.remove(id);
            return true;
        }
        return false;
    }

    public boolean removeServer(String ip) {
        int len = this.m_servers.size();
        for (int i = 0; i < len; ++i) {
            Server server = this.m_servers.get(i);
            if (!server.getIp().equals(ip)) continue;
            this.m_servers.remove(i);
            return true;
        }
        return false;
    }

    public ClientConfig setBind(Bind bind) {
        this.m_bind = bind;
        return this;
    }

    public ClientConfig setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }

    public ClientConfig setDumpLocked(Boolean dumpLocked) {
        this.m_dumpLocked = dumpLocked;
        return this;
    }

    public ClientConfig setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        return this;
    }

    public ClientConfig setMaxMessageSize(int maxMessageSize) {
        this.m_maxMessageSize = maxMessageSize;
        return this;
    }

    public ClientConfig setMode(String mode) {
        this.m_mode = mode;
        return this;
    }
}

