/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum NetworkInterfaceManager {
    INSTANCE;

    private InetAddress m_local;
    public static final String LOOPBACK = "127.0.0.1";

    private NetworkInterfaceManager() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.load();
    }

    public InetAddress findValidateIp(List<InetAddress> addresses) {
        InetAddress local = null;
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            if (address.isLoopbackAddress() || address.isSiteLocalAddress()) {
                if (local == null) {
                    local = address;
                    continue;
                }
                if (address.isSiteLocalAddress() && !address.isLoopbackAddress()) {
                    local = address;
                    continue;
                }
                if (!local.isSiteLocalAddress() || !address.isSiteLocalAddress() || !local.getHostName().equals(local.getHostAddress()) || address.getHostName().equals(address.getHostAddress())) continue;
                local = address;
                continue;
            }
            if (local != null) continue;
            local = address;
        }
        return local;
    }

    public String getLocalHostAddress() {
        return this.m_local.getHostAddress().intern();
    }

    public String getLocalHostName() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = this.m_local.getHostName();
        }
        if (hostname == null) {
            hostname = "unkown";
        } else if (hostname.contains(".sankuai.com") || hostname.contains(".office.mos")) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        return hostname;
    }

    private String getProperty(String name) {
        String value = null;
        value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    private void load() {
        String ip = this.getProperty("host.ip");
        if (ip != null) {
            try {
                this.m_local = InetAddress.getByName(ip);
                return;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            InetAddress local = null;
            try {
                for (NetworkInterface ni : nis) {
                    if (!ni.isUp()) continue;
                    addresses.addAll(Collections.list(ni.getInetAddresses()));
                }
                local = this.findValidateIp(addresses);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_local = local;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

