/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.Cat;
import com.dianping.cat.analyzer.MetricTagAggregator;
import com.dianping.cat.configuration.ApplicationEnvironment;
import com.dianping.cat.configuration.AtomicTreeParser;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.ProblemLongType;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.property.entity.Property;
import com.dianping.cat.configuration.property.entity.PropertyConfig;
import com.dianping.cat.configuration.property.transform.DefaultSaxParser;
import com.dianping.cat.message.spi.MessageTree;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.helper.Files;
import org.unidal.helper.Properties;
import org.unidal.helper.Splitters;
import org.unidal.helper.Urls;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;
import org.xml.sax.SAXException;

@Named(type=ClientConfigManager.class)
public class DefaultClientConfigManager
implements LogEnabled,
ClientConfigManager,
Initializable {
    private ClientConfig m_config;
    private volatile double m_samplingRate = 1.0;
    private volatile boolean m_block = false;
    private String m_routers;
    private AtomicTreeParser m_atomicTreeParser = new AtomicTreeParser();
    private Map<String, Integer> m_longConfigs = new LinkedHashMap<String, Integer>();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public String getDomain() {
        if (this.m_config != null) {
            return this.m_config.getDomain();
        }
        return "unknown";
    }

    @Override
    public int getLongConfigThreshold(String key) {
        Integer value = this.m_longConfigs.get(key);
        if (value == null || value == 0) {
            value = ProblemLongType.findByName(key).getThreshold();
        }
        return value;
    }

    @Override
    public int getMaxMessageChildren() {
        if (this.m_config == null) {
            return 5000;
        }
        return this.m_config.getMaxMessageSize();
    }

    @Override
    public String getRouters() {
        if (this.m_routers == null) {
            this.refreshConfig();
        }
        return this.m_routers;
    }

    @Override
    public double getSamplingRate() {
        return this.m_samplingRate;
    }

    private String getServerConfigUrl(ClientConfig config, int start, int retry) {
        List<Server> servers;
        int size;
        int index;
        if (config == null) {
            return null;
        }
        String ip = null;
        Integer httpPort = null;
        if (this.m_routers != null) {
            ip = this.parseServerIp(this.m_routers);
        }
        if ((index = (start + retry) % (size = (servers = config.getServers()).size())) >= 0 && index < size) {
            Server server = servers.get(index);
            httpPort = server.getHttpPort();
            if (ip == null) {
                ip = server.getIp();
            }
        }
        if (httpPort == null || httpPort == 0) {
            httpPort = 8080;
        }
        if (ip != null) {
            return String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=xml&env=%s", ip.trim(), httpPort, this.getDomain(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), ApplicationEnvironment.ENVIRONMENT);
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        if (this.m_config == null) {
            return Collections.emptyList();
        }
        return this.m_config.getServers();
    }

    public void initialize() {
        String config = System.getProperty("cat-client-config");
        if (StringUtils.isNotEmpty((String)config)) {
            try {
                ClientConfig clientConfig = com.dianping.cat.configuration.client.transform.DefaultSaxParser.parse(config);
                this.initialize(clientConfig);
            }
            catch (Exception e) {
                this.m_logger.error("error in client config " + config, (Throwable)e);
                this.initializeWithDefault();
            }
        } else {
            this.initializeWithDefault();
        }
    }

    @Override
    public void initialize(ClientConfig config) {
        try {
            if (config != null) {
                this.m_config = config;
                this.m_logger.info("setup cat with config:" + config);
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
            this.m_config = new ClientConfig();
        }
    }

    private void initializeWithDefault() {
        String appName = ApplicationEnvironment.loadAppName("unknown");
        try {
            ClientConfig config = ApplicationEnvironment.loadClientConfig(appName);
            config.setDomain(appName);
            this.m_config = config;
            this.m_logger.info("setup cat with default config:" + this.m_config);
        }
        catch (Exception e) {
            this.m_logger.error("error when init cat", (Throwable)e);
            this.m_config = new ClientConfig(appName);
        }
    }

    @Override
    public boolean isAtomicMessage(MessageTree tree) {
        return tree.canDiscard() && this.m_atomicTreeParser.isAtomicMessage(tree);
    }

    private boolean isDevMode() {
        String devMode = (String)Properties.forString().fromEnv().fromSystem().getProperty("devMode", (Object)"false");
        return "true".equals(devMode);
    }

    @Override
    public boolean isMessageBlock() {
        return this.m_block;
    }

    private int parseInteger(PropertyConfig config, String key, int defaultValue) {
        String value = config.findProperty(key).getValue();
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private String parseServerIp(String content) {
        try {
            List strs = Splitters.by((String)";").noEmptyItem().split(content);
            Iterator iterator = strs.iterator();
            if (iterator.hasNext()) {
                String str = (String)iterator.next();
                List items = Splitters.by((String)":").noEmptyItem().split(str);
                return (String)items.get(0);
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void refreshConfig() {
        int retry;
        int start = (int)Math.random() * 10;
        int maxRetryCount = 3;
        boolean refreshStatus = false;
        for (retry = 0; retry < maxRetryCount; ++retry) {
            String url = this.getServerConfigUrl(this.m_config, start, retry);
            try {
                this.refreshWithUrl(url);
                refreshStatus = true;
                break;
            }
            catch (Exception e) {
                this.m_logger.warn("error when connect cat server config url " + url);
                continue;
            }
        }
        if (!refreshStatus && !this.isDevMode()) {
            try {
                String xml = ApplicationEnvironment.loadRemoteClientConfig();
                ClientConfig config = com.dianping.cat.configuration.client.transform.DefaultSaxParser.parse(xml);
                config.setDomain(this.getDomain());
                String url = this.getServerConfigUrl(config, start, 0);
                this.refreshWithUrl(url);
            }
            catch (Exception e) {
                ++retry;
                this.m_logger.warn("error when connect cat server config url from remote config");
            }
        }
    }

    private void refreshWithUrl(String url) throws IOException, SAXException {
        int maxMetricTagValues;
        InputStream inputstream = Urls.forIO().readTimeout(2000).connectTimeout(2000).openStream(url);
        String content = Files.forIO().readFrom(inputstream, "utf-8");
        PropertyConfig routerConfig = DefaultSaxParser.parse(content.trim());
        String newRouters = routerConfig.findProperty("routers").getValue();
        if (this.m_routers == null || !this.m_routers.equals(newRouters)) {
            this.m_routers = newRouters;
            try {
                URL u = new URL(url);
                int httpPort = u.getPort();
                ApplicationEnvironment.storeServers(this.m_routers, httpPort);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.m_samplingRate = Double.parseDouble(routerConfig.findProperty("sample").getValue());
        if (this.m_samplingRate <= 0.0) {
            this.m_samplingRate = 0.0;
        }
        this.m_block = Boolean.parseBoolean(routerConfig.findProperty("block").getValue());
        if (this.m_block) {
            Cat.disable();
        } else {
            Cat.enable();
        }
        String startTypes = routerConfig.findProperty("startTransactionTypes").getValue();
        String matchTypes = routerConfig.findProperty("matchTransactionTypes").getValue();
        for (ProblemLongType longType : ProblemLongType.values()) {
            String name = longType.getName();
            this.m_longConfigs.put(name, this.parseInteger(routerConfig, name, longType.getThreshold()));
        }
        this.m_atomicTreeParser.init(startTypes, matchTypes);
        Property maxMetricProperty = routerConfig.findProperty("maxMetricTagValues");
        if (maxMetricProperty != null && (maxMetricTagValues = Integer.parseInt(maxMetricProperty.getValue())) != MetricTagAggregator.MAX_KEY_SIZE) {
            MetricTagAggregator.MAX_KEY_SIZE = maxMetricTagValues;
        }
    }

    public void setSample(double sample) {
        this.m_samplingRate = sample;
    }
}

