/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.unidal.helper.Files;
import org.unidal.helper.Splitters;
import org.unidal.helper.Urls;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ApplicationEnvironment {
    public static final String HOST = "cat.sankuai.com";
    public static final String PROPERTIES_FILE = "/META-INF/app.properties";
    private static final String CACHE_FILE = "client_cache.xml";
    private static final String CLIENT_FILE = "client.xml";
    public static final String ENVIRONMENT;

    public static void deleteCacheFile() {
        File cacheFile = new File(Cat.getCatHome() + CACHE_FILE);
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    private static boolean isDevMode() {
        String devMode = (String)org.unidal.helper.Properties.forString().fromEnv().fromSystem().getProperty("devMode", (Object)"false");
        return "true".equals(devMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAppName(String defaultDomain) {
        String appName = null;
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                in = Cat.class.getResourceAsStream(PROPERTIES_FILE);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                appName = prop.getProperty("app.name");
                if (appName != null) {
                    String string = appName;
                    return string;
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return defaultDomain;
    }

    public static ClientConfig loadClientConfig(String domain) throws Exception {
        try {
            String xml = null;
            File cacheFile = new File(Cat.getCatHome() + CACHE_FILE);
            File configFile = new File(Cat.getCatHome() + CLIENT_FILE);
            xml = cacheFile.exists() && !ApplicationEnvironment.isDevMode() ? Files.forIO().readFrom(cacheFile, "utf-8") : (configFile.exists() ? Files.forIO().readFrom(configFile, "utf-8") : ApplicationEnvironment.loadRemoteClientConfig());
            ClientConfig config = DefaultSaxParser.parse(xml);
            config.setDomain(domain);
            return config;
        }
        catch (Exception e) {
            throw new Exception("error when init cat client xml", e);
        }
    }

    public static String loadRemoteClientConfig() throws Exception {
        String host = (String)org.unidal.helper.Properties.forString().fromEnv().fromSystem().getProperty("CAT_HOST", (Object)HOST);
        String path = String.format("http://%s/cat/s/launch", host);
        String url = path + "?ip=" + NetworkInterfaceManager.INSTANCE.getLocalHostAddress() + "&env=" + ENVIRONMENT;
        InputStream in = Urls.forIO().readTimeout(3000).connectTimeout(3000).openStream(url);
        return Files.forIO().readFrom(in, "utf-8");
    }

    public static void storeServers(String servers, int httpPort) {
        try {
            ClientConfig config = new ClientConfig();
            List strs = Splitters.by((String)";").noEmptyItem().split(servers);
            for (String str : strs) {
                List items = Splitters.by((String)":").noEmptyItem().split(str);
                config.addServer(new Server().setIp((String)items.get(0)).setHttpPort(httpPort).setPort(Integer.parseInt((String)items.get(1))));
            }
            config.setDomain(null);
            Files.forIO().writeTo(new File(Cat.getCatHome() + CACHE_FILE), config.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String env;
        try {
            String file = "/opt/meituan/apps/sg_agent/sg_agent_env.xml";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(file));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            Node node = (Node)xpath.evaluate("/SGAgentConf/MnsPath", doc, XPathConstants.NODE);
            String text = node.getTextContent();
            env = text.substring(text.lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            env = "unknown";
        }
        ENVIRONMENT = env;
    }
}

