/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analyzer;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricTagAggregator {
    public static MetricTagAggregator s_instance = new MetricTagAggregator();
    public static int MAX_KEY_SIZE = 1000;
    private static final String OTHERS = "others";
    private ConcurrentHashMap<String, Map<String, MetricTagItem>> m_metrics = new ConcurrentHashMap();

    public static MetricTagAggregator getInstance() {
        return s_instance;
    }

    public void addCountMetric(String name, int quantity, Map<String, String> tags) {
        this.makeSureMetricExist(name, tags).m_count.addAndGet(quantity);
    }

    public void addTimerMetric(String name, long durationInMillis, Map<String, String> tags) {
        MetricTagItem item = this.makeSureMetricExist(name, tags);
        item.m_count.incrementAndGet();
        item.m_sum.addAndGet(durationInMillis);
    }

    private void buildMetricMessage(Map<String, Map<String, MetricTagItem>> datas) {
        Transaction transaction = Cat.newTransaction("System", this.getClass().getSimpleName());
        for (Map.Entry<String, Map<String, MetricTagItem>> entry : datas.entrySet()) {
            String key = entry.getKey();
            Map<String, MetricTagItem> items = entry.getValue();
            for (Map.Entry<String, MetricTagItem> tagItem : items.entrySet()) {
                String tagKey = tagItem.getKey();
                MetricTagItem item = tagItem.getValue();
                int count = item.getCount().get();
                long sum = item.getSum().get();
                if (count <= 0) continue;
                if (sum > 0L) {
                    this.logMetric(key, "TD", String.format("%s,%s,%s", count, sum, tagKey));
                    continue;
                }
                this.logMetric(key, "TC", String.format("%s,%s,%s", count, count, tagKey));
            }
        }
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        tree.setDomain(this.getDomain(tree));
        tree.setDiscard(false);
        transaction.setStatus("0");
        transaction.complete();
    }

    private String buildTagKey(Map<String, String> tags) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            if (!first) {
                sb.append('&');
            } else {
                first = false;
            }
            sb.append(tag.getKey()).append('=').append(tag.getValue());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, MetricTagItem>> getAndResetMetrics() {
        ConcurrentHashMap<String, Map<String, MetricTagItem>> cloned = this.m_metrics;
        MetricTagAggregator metricTagAggregator = this;
        synchronized (metricTagAggregator) {
            this.m_metrics = new ConcurrentHashMap();
            for (Map.Entry entry : cloned.entrySet()) {
                String key = (String)entry.getKey();
                Map items = (Map)entry.getValue();
                ConcurrentHashMap newItem = new ConcurrentHashMap();
                for (Map.Entry tagItem : items.entrySet()) {
                    if (((MetricTagItem)tagItem.getValue()).getCount().get() <= 0) continue;
                    newItem.put(tagItem.getKey(), new MetricTagItem());
                }
                this.m_metrics.put(key, newItem);
            }
        }
        return cloned;
    }

    public String getDomain(MessageTree tree) {
        return tree.getDomain();
    }

    private void logMetric(String name, String status, String keyValuePairs) {
        try {
            Cat.getProducer().logMetric(name, status, keyValuePairs);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetricTagItem makeSureMetricExist(String key, Map<String, String> tags) {
        String tagKey;
        MetricTagItem item;
        Map<String, MetricTagItem> items = this.m_metrics.get(key);
        if (null == items) {
            MetricTagAggregator metricTagAggregator = this;
            synchronized (metricTagAggregator) {
                items = this.m_metrics.get(key);
                if (null == items) {
                    items = new ConcurrentHashMap<String, MetricTagItem>();
                    this.m_metrics.put(key, items);
                }
            }
        }
        if (null != (item = items.get(tagKey = this.buildTagKey(tags)))) return item;
        if (items.size() >= MAX_KEY_SIZE) {
            Cat.logEvent("cat.TooManyTagValuesForMetric", key);
            tagKey = OTHERS;
        }
        if (null != (item = items.get(tagKey))) return item;
        Class<MetricTagAggregator> clazz = MetricTagAggregator.class;
        synchronized (MetricTagAggregator.class) {
            item = items.get(tagKey);
            if (null != item) return item;
            item = new MetricTagItem();
            items.put(tagKey, item);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return item;
        }
    }

    public void sendMetricTagData() {
        Map<String, Map<String, MetricTagItem>> items = this.getAndResetMetrics();
        if (items.size() > 0) {
            this.buildMetricMessage(items);
        }
    }

    public class MetricTagItem {
        private String m_key;
        private AtomicInteger m_count = new AtomicInteger();
        private AtomicLong m_sum = new AtomicLong();

        public AtomicInteger getCount() {
            return this.m_count;
        }

        public String getKey() {
            return this.m_key;
        }

        public AtomicLong getSum() {
            return this.m_sum;
        }

        public void setCount(AtomicInteger count) {
            this.m_count = count;
        }

        public void setKey(String key) {
            this.m_key = key;
        }
    }
}

