/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analyzer;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricAggregator {
    public static MetricAggregator s_instance = new MetricAggregator();
    private ConcurrentHashMap<String, MetricItem> m_metrics = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> m_metricThresholds = new ConcurrentHashMap();

    public static MetricAggregator getInstance() {
        return s_instance;
    }

    public void addCountMetric(String key, int value) {
        this.makeSureMetricExist(key).m_count.addAndGet(value);
    }

    public void addTimerMetric(String key, long mills) {
        MetricItem item = this.makeSureMetricExist(key);
        item.m_count.incrementAndGet();
        item.m_sum.addAndGet(mills);
        if (item.m_slowThreshold > 0 && mills > (long)item.m_slowThreshold) {
            item.m_slowCount.incrementAndGet();
        }
    }

    private void buildMetricMessage(Map<String, MetricItem> items) {
        Transaction transaction = Cat.newTransaction("System", this.getClass().getSimpleName());
        for (Map.Entry<String, MetricItem> entry : items.entrySet()) {
            String name = entry.getKey();
            MetricItem item = entry.getValue();
            int count = item.getCount().get();
            long sum = entry.getValue().getSum().get();
            int slowCount = item.getSlowCount();
            if (sum > 0L) {
                this.logMetric(name, "S,C", String.format("%s,%s", count, sum));
            } else if (count > 0) {
                if (item.isLatested()) {
                    this.logMetric(name, "L", String.valueOf(count));
                } else {
                    this.logMetric(name, "C", String.valueOf(count));
                }
            }
            if (slowCount <= 0) continue;
            this.logMetric(name + ".slowCount", "C", String.valueOf(item.getSlowCount()));
        }
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        tree.setDiscard(false);
        tree.setDomain(this.getDomain(tree));
        transaction.setStatus("0");
        transaction.complete();
    }

    private MetricItem createMetricItem(String key) {
        MetricItem item = new MetricItem().setKey(key);
        Integer threshold = this.m_metricThresholds.get(key);
        if (threshold != null) {
            item.setSlowThreshold(threshold);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, MetricItem> getAndResetMetrics() {
        ConcurrentHashMap<String, MetricItem> cloned = this.m_metrics;
        MetricAggregator metricAggregator = this;
        synchronized (metricAggregator) {
            this.m_metrics = new ConcurrentHashMap();
            for (Map.Entry entry : cloned.entrySet()) {
                String key = (String)entry.getKey();
                this.m_metrics.put(key, this.createMetricItem(key));
            }
        }
        return cloned;
    }

    public String getDomain(MessageTree tree) {
        return tree.getDomain();
    }

    private void logMetric(String name, String status, String keyValuePairs) {
        try {
            Cat.getProducer().logMetric(name, status, keyValuePairs);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void logMetricForLatestValue(String name, int quantity) {
        MetricItem item = this.makeSureMetricExist(name);
        item.m_count.set(quantity);
        item.setLatested(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricItem makeSureMetricExist(String key) {
        MetricItem item = this.m_metrics.get(key);
        if (null == item) {
            MetricAggregator metricAggregator = this;
            synchronized (metricAggregator) {
                item = this.m_metrics.get(key);
                if (null == item) {
                    item = this.createMetricItem(key);
                    this.m_metrics.put(key, item);
                }
            }
        }
        return item;
    }

    public void sendMetricData() {
        Map<String, MetricItem> items = this.getAndResetMetrics();
        if (items.size() > 0) {
            this.buildMetricMessage(items);
        }
    }

    public void setMetricSlowThreshold(String key, int slow) {
        this.m_metricThresholds.put(key, slow);
    }

    public class MetricItem {
        private String m_key;
        private int m_slowThreshold;
        private AtomicInteger m_count = new AtomicInteger();
        private AtomicInteger m_slowCount = new AtomicInteger();
        private AtomicLong m_sum = new AtomicLong();
        private boolean m_latested = false;

        public AtomicInteger getCount() {
            return this.m_count;
        }

        public String getKey() {
            return this.m_key;
        }

        public int getSlowCount() {
            return this.m_slowCount.get();
        }

        public int getSlowThreshold() {
            return this.m_slowThreshold;
        }

        public AtomicLong getSum() {
            return this.m_sum;
        }

        public boolean isLatested() {
            return this.m_latested;
        }

        public MetricItem setKey(String key) {
            this.m_key = key;
            return this;
        }

        public void setLatested(boolean latested) {
            this.m_latested = latested;
        }

        public void setSlowThreshold(int slowThreshold) {
            this.m_slowThreshold = slowThreshold;
        }
    }
}

